/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.FloatingPointValue;
import org.neo4j.values.NumberType;
import org.neo4j.values.NumberValue;
import org.neo4j.values.NumberValues;
import org.neo4j.values.Value;

abstract class IntegralValue
extends NumberValue {
    IntegralValue() {
    }

    abstract long longValue();

    @Override
    public final int hashCode() {
        return NumberValues.hash(this.longValue());
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public final boolean equals(Value other) {
        if (other instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other;
            return this.longValue() == that.longValue();
        }
        if (other instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other;
            return NumberValues.numbersEqual(that.doubleValue(), this.longValue());
        }
        return false;
    }

    @Override
    public int compareTo(IntegralValue other) {
        return Long.compare(this.longValue(), other.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other) {
        return NumberValues.compareLongAgainstDouble(this.longValue(), other.doubleValue());
    }

    @Override
    public NumberType numberType() {
        return NumberType.INTEGRAL;
    }
}

