/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Arrays;
import org.neo4j.values.ArrayValue;
import org.neo4j.values.NumberType;
import org.neo4j.values.NumberValues;
import org.neo4j.values.PrimitiveArrayWriting;
import org.neo4j.values.Value;
import org.neo4j.values.ValueGroup;
import org.neo4j.values.ValueWriter;

abstract class BooleanArray
extends ArrayValue {
    BooleanArray() {
    }

    abstract boolean[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    public boolean booleanValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(byte[] x) {
        return false;
    }

    @Override
    public boolean equals(short[] x) {
        return false;
    }

    @Override
    public boolean equals(int[] x) {
        return false;
    }

    @Override
    public boolean equals(long[] x) {
        return false;
    }

    @Override
    public boolean equals(float[] x) {
        return false;
    }

    @Override
    public boolean equals(double[] x) {
        return false;
    }

    @Override
    public boolean equals(boolean[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(char[] x) {
        return false;
    }

    @Override
    public boolean equals(String[] x) {
        return false;
    }

    @Override
    public int hashCode() {
        return NumberValues.hash(this.value());
    }

    public void writeTo(ValueWriter writer) {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asObjectCopy() {
        return this.value().clone();
    }

    @Override
    @Deprecated
    public Object asObject() {
        return this.value();
    }

    public int compareTo(BooleanArray other) {
        return NumberValues.compareBooleanArrays(this, other);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN_ARRAY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value());
    }

    static final class Direct
    extends BooleanArray {
        private final boolean[] value;

        Direct(boolean[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        boolean[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("BooleanArray%s", Arrays.toString(this.value()));
        }
    }
}

