/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.Value;

public class ValueTuple {
    private final Value[] values;

    public static ValueTuple of(Value ... values) {
        assert (values.length > 0) : "Empty ValueTuple is not allowed";
        assert (ValueTuple.noNulls(values));
        return new ValueTuple(values);
    }

    private ValueTuple(Value[] values) {
        this.values = values;
    }

    public int size() {
        return this.values.length;
    }

    public Value valueAt(int offset) {
        return this.values[offset];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueTuple that = (ValueTuple)o;
        if (that.values.length != this.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Value value : this.values) {
            result = 31 * result + ((Object)value).hashCode();
        }
        return result;
    }

    public Value getOnlyValue() {
        assert (this.values.length == 1) : "Assumed single value tuple, but had " + this.values.length;
        return this.values[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "( ";
        for (Value value : this.values) {
            sb.append(sep);
            sep = ", ";
            sb.append(value);
        }
        sb.append(" )");
        return sb.toString();
    }

    private static boolean noNulls(Value[] values) {
        for (Value v : values) {
            if (v != null) continue;
            return false;
        }
        return true;
    }
}

