/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import org.neo4j.values.BooleanArray;
import org.neo4j.values.BooleanValue;
import org.neo4j.values.FloatingPointArray;
import org.neo4j.values.FloatingPointValue;
import org.neo4j.values.IntegralArray;
import org.neo4j.values.IntegralValue;
import org.neo4j.values.NumberType;
import org.neo4j.values.TextArray;
import org.neo4j.values.TextValue;
import org.neo4j.values.Value;
import org.neo4j.values.ValueGroup;
import org.neo4j.values.VirtualValue;

class ValueComparator
implements Comparator<Value> {
    private final Comparator<ValueGroup> valueGroupComparator;
    private final Comparator<VirtualValue> virtualValueComparator;

    ValueComparator(Comparator<ValueGroup> valueGroupComparator, Comparator<VirtualValue> virtualValueComparator) {
        this.valueGroupComparator = valueGroupComparator;
        this.virtualValueComparator = virtualValueComparator;
    }

    @Override
    public int compare(Value v1, Value v2) {
        ValueGroup id2;
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        ValueGroup id1 = v1.valueGroup();
        int x = this.valueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            switch (id1) {
                case NO_VALUE: {
                    return x;
                }
                case NUMBER: {
                    switch (v1.numberType()) {
                        case INTEGRAL: {
                            return this.compareNumberScalar((IntegralValue)v1, v2);
                        }
                        case FLOATING_POINT: {
                            return this.compareNumberScalar((FloatingPointValue)v1, v2);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Cannot handle ValueGroup id '%s' that is not Integral of FloatingPoint", new Object[]{id1}));
                }
                case TEXT: {
                    return ((TextValue)v1).compareTo((TextValue)v2);
                }
                case BOOLEAN: {
                    return ((BooleanValue)v1).compareTo((BooleanValue)v2);
                }
                case NUMBER_ARRAY: {
                    switch (v1.numberType()) {
                        case INTEGRAL: {
                            return this.compareNumberArray((IntegralArray)v1, v2);
                        }
                        case FLOATING_POINT: {
                            return this.compareNumberArray((FloatingPointArray)v1, v2);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Cannot handle ValueGroup id '%s' that is not Integral of FloatingPoint", new Object[]{id1}));
                }
                case TEXT_ARRAY: {
                    return ((TextArray)v1).compareTo((TextArray)v2);
                }
                case BOOLEAN_ARRAY: {
                    return ((BooleanArray)v1).compareTo((BooleanArray)v2);
                }
                case VIRTUAL: {
                    return this.virtualValueComparator.compare((VirtualValue)v1, (VirtualValue)v2);
                }
            }
            throw new UnsupportedOperationException(String.format("Unknown ValueGroup id '%s'", new Object[]{id1}));
        }
        return x;
    }

    private int compareNumberScalar(IntegralValue v1, Value v2) {
        switch (v2.valueGroup()) {
            case NUMBER: {
                switch (v2.numberType()) {
                    case INTEGRAL: {
                        return v1.compareTo((IntegralValue)v2);
                    }
                    case FLOATING_POINT: {
                        return v1.compareTo((FloatingPointValue)v2);
                    }
                }
                throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{NumberType.INTEGRAL, v2.valueGroup()}));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{ValueGroup.NUMBER, v2.valueGroup()}));
    }

    private int compareNumberScalar(FloatingPointValue v1, Value v2) {
        switch (v2.valueGroup()) {
            case NUMBER: {
                switch (v2.numberType()) {
                    case INTEGRAL: {
                        return v1.compareTo((IntegralValue)v2);
                    }
                    case FLOATING_POINT: {
                        return v1.compareTo((FloatingPointValue)v2);
                    }
                }
                throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{NumberType.FLOATING_POINT, v2.valueGroup()}));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{ValueGroup.NUMBER, v2.valueGroup()}));
    }

    private int compareNumberArray(IntegralArray v1, Value v2) {
        switch (v2.valueGroup()) {
            case NUMBER_ARRAY: {
                switch (v2.numberType()) {
                    case INTEGRAL: {
                        return v1.compareTo((IntegralArray)v2);
                    }
                    case FLOATING_POINT: {
                        return v1.compareTo((FloatingPointArray)v2);
                    }
                }
                throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{NumberType.FLOATING_POINT, v2.valueGroup()}));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{ValueGroup.NUMBER, v2.valueGroup()}));
    }

    private int compareNumberArray(FloatingPointArray v1, Value v2) {
        switch (v2.valueGroup()) {
            case NUMBER_ARRAY: {
                switch (v2.numberType()) {
                    case INTEGRAL: {
                        return v1.compareTo((IntegralArray)v2);
                    }
                    case FLOATING_POINT: {
                        return v1.compareTo((FloatingPointArray)v2);
                    }
                }
                throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{NumberType.FLOATING_POINT, v2.valueGroup()}));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot compare values of type %s with type %s", new Object[]{ValueGroup.NUMBER, v2.valueGroup()}));
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ValueComparator;
    }

    public int hashCode() {
        return 1;
    }
}

