/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.LazyValue;
import org.neo4j.values.LazyValues;
import org.neo4j.values.TextValue;
import org.neo4j.values.Value;
import org.neo4j.values.ValueWriter;
import org.neo4j.values.Values;

abstract class StringValue
extends TextValue {
    StringValue() {
    }

    abstract String value();

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value value) {
        return value.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public int hashCode() {
        return this.value().hashCode();
    }

    @Override
    public void writeTo(ValueWriter writer) {
        writer.writeString(this.value());
    }

    @Override
    public Object asPublic() {
        return this.value();
    }

    public String toString() {
        return String.format("String(\"%s\")", this.value());
    }

    @Override
    public int compareTo(TextValue other) {
        return this.value().compareTo(other.stringValue());
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    static final class Lazy
    extends StringValue
    implements LazyValue<String> {
        private volatile Object field;

        Lazy(Values.ValueLoader<String> producer) {
            this.field = producer;
        }

        @Override
        String value() {
            return LazyValues.getOrLoad(this);
        }

        @Override
        public void registerValue(String value) {
            this.field = value;
        }

        @Override
        public Object getMaybeValue() {
            return this.field;
        }
    }

    static final class Direct
    extends StringValue {
        final String value;

        Direct(String value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String value() {
            return this.value;
        }
    }
}

