/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Arrays;
import org.neo4j.values.LazyValue;
import org.neo4j.values.LazyValues;
import org.neo4j.values.PrimitiveArrayValues;
import org.neo4j.values.PrimitiveArrayWriting;
import org.neo4j.values.TextArray;
import org.neo4j.values.TextValues;
import org.neo4j.values.Value;
import org.neo4j.values.ValueWriter;
import org.neo4j.values.Values;

abstract class StringArray
extends TextArray {
    StringArray() {
    }

    abstract String[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value());
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public int hashCode() {
        return TextValues.hash(this.value());
    }

    @Override
    public void writeTo(ValueWriter writer) {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asPublic() {
        return this.value().clone();
    }

    @Override
    public int compareTo(TextArray other) {
        return TextValues.compareTextArrays(this, other);
    }

    static final class Lazy
    extends StringArray
    implements LazyValue<String[]> {
        private volatile Object field;

        Lazy(Values.ValueLoader<String[]> producer) {
            this.field = producer;
        }

        @Override
        String[] value() {
            return LazyValues.getOrLoad(this);
        }

        @Override
        public void registerValue(String[] value) {
            this.field = value;
        }

        @Override
        public Object getMaybeValue() {
            return this.field;
        }

        public String toString() {
            return String.format("StringArray%s", LazyValues.valueIsLoaded(this.field) ? Arrays.toString(this.value()) : "?");
        }
    }

    static final class Direct
    extends StringArray {
        final String[] value;

        Direct(String[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        String[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("StringArray%s", Arrays.toString(this.value()));
        }
    }
}

