/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.ValueWriter;

public class PrimitiveArrayWriting {
    public static void writeTo(ValueWriter writer, byte[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.BYTE);
        for (byte x : values) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, short[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.SHORT);
        for (short x : values) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, int[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.INT);
        for (int x : values) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, long[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.LONG);
        for (long x : values) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, float[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.FLOAT);
        for (float x : values) {
            writer.writeFloatingPoint(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, double[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.DOUBLE);
        for (double x : values) {
            writer.writeFloatingPoint(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, boolean[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.BOOLEAN);
        for (boolean x : values) {
            writer.writeBoolean(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, char[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.CHAR);
        for (char x : values) {
            writer.writeString(x);
        }
        writer.endArray();
    }

    public static void writeTo(ValueWriter writer, String[] values) {
        writer.beginArray(values.length, ValueWriter.ArrayType.STRING);
        for (String x : values) {
            writer.writeString(x);
        }
        writer.endArray();
    }
}

