/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.IntegralValue;
import org.neo4j.values.NumberType;
import org.neo4j.values.NumberValue;
import org.neo4j.values.NumberValues;
import org.neo4j.values.Value;

abstract class FloatingPointValue
extends NumberValue {
    FloatingPointValue() {
    }

    abstract double doubleValue();

    @Override
    public final int hashCode() {
        return NumberValues.hash(this.doubleValue());
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public final boolean equals(Value other) {
        if (other instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other;
            return this.doubleValue() == that.doubleValue();
        }
        if (other instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other;
            return NumberValues.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    public NumberType numberType() {
        return NumberType.FLOATING_POINT;
    }

    @Override
    public int compareTo(IntegralValue other) {
        return NumberValues.compareDoubleAgainstLong(this.doubleValue(), other.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other) {
        return Double.compare(this.doubleValue(), other.doubleValue());
    }
}

