/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Arrays;
import org.neo4j.values.LazyValue;
import org.neo4j.values.LazyValues;
import org.neo4j.values.PrimitiveArrayValues;
import org.neo4j.values.PrimitiveArrayWriting;
import org.neo4j.values.TextArray;
import org.neo4j.values.TextValues;
import org.neo4j.values.Value;
import org.neo4j.values.ValueWriter;
import org.neo4j.values.Values;

abstract class CharArray
extends TextArray {
    CharArray() {
    }

    abstract char[] value();

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(char[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(String[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public int hashCode() {
        return TextValues.hash(this.value());
    }

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public String stringValue(int offset) {
        return Character.toString(this.value()[offset]);
    }

    @Override
    public void writeTo(ValueWriter writer) {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asPublic() {
        return this.value().clone();
    }

    static final class Lazy
    extends CharArray
    implements LazyValue<char[]> {
        private volatile Object field;

        Lazy(Values.ValueLoader<char[]> producer) {
            this.field = producer;
        }

        @Override
        char[] value() {
            return LazyValues.getOrLoad(this);
        }

        @Override
        public void registerValue(char[] value) {
            this.field = value;
        }

        @Override
        public Object getMaybeValue() {
            return this.field;
        }

        public String toString() {
            return String.format("CharArray%s", LazyValues.valueIsLoaded(this.field) ? Arrays.toString(this.value()) : "?");
        }
    }

    static final class Direct
    extends CharArray {
        final char[] value;

        Direct(char[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        char[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("CharArray%s", Arrays.toString(this.value()));
        }
    }
}

