/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Arrays;
import org.neo4j.values.IntegralArray;
import org.neo4j.values.LazyValue;
import org.neo4j.values.LazyValues;
import org.neo4j.values.NumberValues;
import org.neo4j.values.PrimitiveArrayValues;
import org.neo4j.values.PrimitiveArrayWriting;
import org.neo4j.values.Value;
import org.neo4j.values.ValueWriter;
import org.neo4j.values.Values;

abstract class ByteArray
extends IntegralArray {
    ByteArray() {
    }

    abstract byte[] value();

    @Override
    public int length() {
        return this.value().length;
    }

    @Override
    public long longValue(int index) {
        return this.value()[index];
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public int hashCode() {
        return NumberValues.hash(this.value());
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value());
    }

    @Override
    public boolean equals(byte[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value(), x);
    }

    @Override
    public void writeTo(ValueWriter writer) {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public Object asPublic() {
        return this.value().clone();
    }

    static final class Lazy
    extends ByteArray
    implements LazyValue<byte[]> {
        private volatile Object field;

        Lazy(Values.ValueLoader<byte[]> producer) {
            this.field = producer;
        }

        @Override
        byte[] value() {
            return LazyValues.getOrLoad(this);
        }

        @Override
        public void registerValue(byte[] value) {
            this.field = value;
        }

        @Override
        public Object getMaybeValue() {
            return this.field;
        }

        public String toString() {
            return String.format("ByteArray%s", LazyValues.valueIsLoaded(this.field) ? Arrays.toString(this.value()) : "?");
        }
    }

    static final class Direct
    extends ByteArray {
        final byte[] value;

        Direct(byte[] value) {
            assert (value != null);
            this.value = value;
        }

        @Override
        byte[] value() {
            return this.value;
        }

        public String toString() {
            return String.format("ByteArray%s", Arrays.toString(this.value));
        }
    }
}

