/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import org.neo4j.values.NumberType;
import org.neo4j.values.ScalarValue;
import org.neo4j.values.Value;
import org.neo4j.values.ValueGroup;
import org.neo4j.values.ValueWriter;

final class BooleanValue
extends ScalarValue {
    private final boolean bool;

    BooleanValue(boolean bool) {
        this.bool = bool;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.bool);
    }

    @Override
    public boolean equals(boolean x) {
        return this.bool == x;
    }

    @Override
    public boolean equals(char x) {
        return false;
    }

    @Override
    public boolean equals(String x) {
        return false;
    }

    @Override
    public int hashCode() {
        return this.bool ? -1 : 0;
    }

    public boolean booleanValue() {
        return this.bool;
    }

    public int compareTo(BooleanValue other) {
        return Boolean.compare(this.bool, other.booleanValue());
    }

    @Override
    public void writeTo(ValueWriter writer) {
        writer.writeBoolean(this.bool);
    }

    @Override
    public Object asPublic() {
        return this.bool;
    }

    public String toString() {
        return String.format("Boolean('%s')", Boolean.toString(this.bool));
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }
}

