/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.graphdb.Vector;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralVector;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class Int8Vector
extends IntegralVector {
    public static final String NESTED_TYPE_NAME = "INTEGER8";
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Int8Vector.class);
    private final byte[] coordinates;

    Int8Vector(byte ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public float floatValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public int dimensions() {
        return this.coordinates.length;
    }

    @Override
    public String getTypeName() {
        return "Int8Vector";
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.INT8_VECTOR;
    }

    public Vector.CoordinateType coordinateType() {
        return Vector.CoordinateType.INTEGER8;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof Int8Vector) {
            Int8Vector v = (Int8Vector)other;
            return Arrays.equals(this.coordinates, v.coordinates);
        }
        return false;
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        Int8Vector that = (Int8Vector)other;
        int comparison = Integer.compare(this.dimensions(), that.dimensions());
        if (comparison != 0) {
            return comparison;
        }
        return Arrays.compare(this.coordinates, that.coordinates);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeInt8Vector(this.coordinates);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapInt8Vector(this);
    }

    @Override
    protected long longBits(int i) {
        return this.coordinates[i];
    }

    @Override
    public String nestedTypeName() {
        return NESTED_TYPE_NAME;
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.coordinates);
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((byte[])this.coordinates);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.coordinates));
    }
}

