/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.graphdb.Vector;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointVector;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class Float32Vector
extends FloatingPointVector {
    public static final String NESTED_TYPE_NAME = "FLOAT32";
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Float32Vector.class);
    private final float[] coordinates;

    Float32Vector(float ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public float floatValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public int dimensions() {
        return this.coordinates.length;
    }

    @Override
    public String getTypeName() {
        return "Float32Vector";
    }

    public Vector.CoordinateType coordinateType() {
        return Vector.CoordinateType.FLOAT32;
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.FLOAT32_VECTOR;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof Float32Vector) {
            Float32Vector v = (Float32Vector)other;
            return Arrays.equals(this.coordinates, v.coordinates);
        }
        return false;
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        Float32Vector that = (Float32Vector)other;
        int comparison = Integer.compare(this.dimensions(), that.dimensions());
        if (comparison != 0) {
            return comparison;
        }
        return Arrays.compare(this.coordinates, that.coordinates);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloat32Vector(this.coordinates);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapFloat32Vector(this);
    }

    @Override
    protected long longBits(int i) {
        return Double.doubleToLongBits(this.coordinates[i]);
    }

    @Override
    public String nestedTypeName() {
        return NESTED_TYPE_NAME;
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.coordinates);
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((float[])this.coordinates);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.coordinates));
    }
}

