/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.neo4j.util.VisibleForTesting;

public final class SimpleIdentityCache<K, V> {
    private final K[] keys;
    private final V[] values;
    private int next;

    public SimpleIdentityCache(int size) {
        this.keys = new Object[size];
        this.values = new Object[size];
    }

    public V getOrCache(K key, Function<V, V> supplier) {
        V value = this.get(key);
        if (value == null) {
            value = supplier.apply(this.values[this.next]);
            this.keys[this.next] = key;
            this.values[this.next] = value;
            this.next = (this.next + 1) % this.keys.length;
        }
        return value;
    }

    @VisibleForTesting
    V get(K key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (key != this.keys[i]) continue;
            return this.values[i];
        }
        return null;
    }

    public void foreach(BiConsumer<K, V> consumer) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            consumer.accept(this.keys[i], this.values[i]);
        }
    }
}

