/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointVector;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class Float32Vector
extends FloatingPointVector {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Float32Vector.class);
    private final float[] coordinates;

    Float32Vector(float ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public int dimensions() {
        return this.coordinates.length;
    }

    @Override
    public String getTypeName() {
        return "Float32Vector";
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.FLOAT32_VECTOR;
    }

    @Override
    public Object asObjectCopy() {
        return null;
    }

    @Override
    public boolean equals(Value other) {
        return false;
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        return 0;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return null;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return 0L;
    }

    @Override
    protected int computeHashToMemoize() {
        return 0;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((float[])this.coordinates);
    }
}

