/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.TemporalParseException;
import org.neo4j.exceptions.UnsupportedTemporalUnitException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.Neo4JTemporalField;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;

public final class DateValue
extends TemporalValue<LocalDate, DateValue> {
    private static final long INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(DateValue.class) + HeapEstimator.LOCAL_DATE_SIZE;
    public static final DateValue MIN_VALUE = new DateValue(LocalDate.MIN);
    public static final DateValue MAX_VALUE = new DateValue(LocalDate.MAX);
    private final LocalDate value;
    static final boolean QUARTER_DATES = FeatureToggles.flag(DateValue.class, (String)"QUARTER_DATES", (boolean)true);
    static final String DATE_PATTERN = "(?:(?<shortYear>[0-9]{4})(?:(?<shortMonth>[0-9]{2})(?<shortDay>[0-9]{2})?|W(?<shortWeek>[0-9]{2})(?<shortDOW>[0-9])?|" + (QUARTER_DATES ? "Q(?<shortQuarter>[0-9])(?<shortDOQ>[0-9]{2})?|" : "") + "(?<shortDOY>[0-9]{3}))|(?<longYear>(?:[0-9]{4}|[+-][0-9]{1,9}))(?:-(?<longMonth>[0-9]{1,2})(?:-(?<longDay>[0-9]{1,2}))?|-?W(?<longWeek>[0-9]{1,2})(?:-(?<longDOW>[0-9]))?|" + (QUARTER_DATES ? "-?Q(?<longQuarter>[0-9])(?:-(?<longDOQ>[0-9]{1,2}))?|" : "") + "-(?<longDOY>[0-9]{3}))?)";
    private static final Pattern PATTERN = Pattern.compile(DATE_PATTERN);
    static final LocalDate DEFAULT_CALENDER_DATE = LocalDate.of(TemporalValue.TemporalFields.year.defaultValue, TemporalValue.TemporalFields.month.defaultValue, TemporalValue.TemporalFields.day.defaultValue);

    private DateValue(LocalDate value) {
        this.value = value;
    }

    public static DateValue date(LocalDate value) {
        return new DateValue(Objects.requireNonNull(value, "LocalDate"));
    }

    public static DateValue date(int year, int month, int day) {
        return new DateValue(DateValue.assertValidArgument(() -> LocalDate.of(year, month, day)));
    }

    public static DateValue weekDate(int year, int week, int dayOfWeek) {
        return new DateValue(DateValue.assertValidArgument(() -> DateValue.localWeekDate(year, week, dayOfWeek)));
    }

    public static DateValue quarterDate(int year, int quarter, int dayOfQuarter) {
        return new DateValue(DateValue.assertValidArgument(() -> DateValue.localQuarterDate(year, quarter, dayOfQuarter)));
    }

    public static DateValue ordinalDate(int year, int dayOfYear) {
        return new DateValue(DateValue.assertValidArgument(() -> LocalDate.ofYearDay(year, dayOfYear)));
    }

    public static DateValue epochDate(long epochDay) {
        return new DateValue(DateValue.epochDateRaw(epochDay));
    }

    public static LocalDate epochDateRaw(long epochDay) {
        return DateValue.assertValidArgument(() -> LocalDate.ofEpochDay(epochDay));
    }

    public static DateValue parse(CharSequence text) {
        return DateValue.parse(DateValue.class, PATTERN, DateValue::parse, text);
    }

    public static DateValue parse(TextValue text) {
        return DateValue.parse(DateValue.class, PATTERN, DateValue::parse, text);
    }

    public static DateValue now(Clock clock) {
        return new DateValue(LocalDate.now(clock));
    }

    public static DateValue now(Clock clock, String timezone) {
        return DateValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static DateValue now(Clock clock, Supplier<ZoneId> defaultZone) {
        return DateValue.now(clock.withZone(defaultZone.get()));
    }

    public static DateValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return StructureBuilder.build(DateValue.builder(defaultZone), map);
    }

    public static DateValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        DateValue.builder(defaultZone);
        return DateBuilder.selectDate(from);
    }

    public static DateValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        LocalDate localDate = input.getDatePart();
        DateValue truncated = DateValue.date(DateValue.truncateTo(localDate, unit));
        if (fields.isEmpty()) {
            return truncated;
        }
        MapValue updatedFields = fields.updatedWith("date", truncated);
        return DateValue.build(updatedFields, defaultZone);
    }

    static LocalDate truncateTo(LocalDate value, TemporalUnit unit) {
        if (unit == ChronoUnit.MILLENNIA) {
            return value.with(Neo4JTemporalField.YEAR_OF_MILLENNIUM, 0L);
        }
        if (unit == ChronoUnit.CENTURIES) {
            return value.with(Neo4JTemporalField.YEAR_OF_CENTURY, 0L);
        }
        if (unit == ChronoUnit.DECADES) {
            return value.with(Neo4JTemporalField.YEAR_OF_DECADE, 0L);
        }
        if (unit == ChronoUnit.YEARS) {
            return value.with(TemporalAdjusters.firstDayOfYear());
        }
        if (unit == IsoFields.WEEK_BASED_YEARS) {
            return value.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L);
        }
        if (unit == IsoFields.QUARTER_YEARS) {
            return value.with(IsoFields.DAY_OF_QUARTER, 1L);
        }
        if (unit == ChronoUnit.MONTHS) {
            return value.with(TemporalAdjusters.firstDayOfMonth());
        }
        if (unit == ChronoUnit.WEEKS) {
            return value.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        }
        if (unit == ChronoUnit.DAYS) {
            return value;
        }
        throw UnsupportedTemporalUnitException.tooSmallUnitForTruncate((String)String.valueOf(unit), (String)String.valueOf(value));
    }

    private static DateBuilder builder(Supplier<ZoneId> defaultZone) {
        return new DateBuilder(defaultZone);
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        DateValue other = (DateValue)otherValue;
        return this.value.compareTo(other.value);
    }

    @Override
    public String getTypeName() {
        return "Date";
    }

    @Override
    LocalDate temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        return this.value;
    }

    @Override
    LocalTime getLocalTimePart() {
        throw UnsupportedTemporalUnitException.cannotGetLocalTime((String)String.valueOf(this));
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        throw UnsupportedTemporalUnitException.cannotGetZonedTime((String)String.valueOf(this));
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        throw UnsupportedTemporalUnitException.cannotGetTimezone((String)String.valueOf(this));
    }

    @Override
    ZoneOffset getZoneOffset() {
        throw UnsupportedTemporalUnitException.cannotGetZoneOffset((String)String.valueOf(this));
    }

    @Override
    public boolean supportsTimeZone() {
        return false;
    }

    @Override
    boolean hasTime() {
        return false;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof DateValue && this.value.equals(((DateValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeDate(this.value);
    }

    @Override
    public String prettyPrint() {
        return DateValue.assertPrintable(String.valueOf(this.value), () -> this.value.format(DateTimeFormatter.ISO_DATE));
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.DATE;
    }

    @Override
    protected int computeHashToMemoize() {
        return Long.hashCode(this.value.toEpochDay());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDate(this);
    }

    public DateValue add(DurationValue duration) {
        return this.replacement(DateValue.assertValidArithmetic(() -> this.value.plusMonths(duration.totalMonths()).plusDays(duration.totalDays())));
    }

    public DateValue sub(DurationValue duration) {
        return this.replacement(DateValue.assertValidArithmetic(() -> this.value.minusMonths(duration.totalMonths()).minusDays(duration.totalDays())));
    }

    @Override
    DateValue replacement(LocalDate date) {
        return date == this.value ? this : new DateValue(date);
    }

    static LocalDate parseDate(Matcher matcher) {
        String longYear = matcher.group("longYear");
        if (longYear != null) {
            return DateValue.parse(matcher, Integer.parseInt(longYear), "longMonth", "longDay", "longWeek", "longDOW", "longQuarter", "longDOQ", "longDOY");
        }
        return DateValue.parse(matcher, Integer.parseInt(matcher.group("shortYear")), "shortMonth", "shortDay", "shortWeek", "shortDOW", "shortQuarter", "shortDOQ", "shortDOY");
    }

    private static LocalDate parse(Matcher matcher, int year, String MONTH, String DAY, String WEEK, String DOW, String QUARTER, String DOQ, String DOY) {
        String month = matcher.group(MONTH);
        if (month != null) {
            String day = matcher.group(DAY);
            if (day == null && month.length() == 1) {
                throw TemporalParseException.cannotParseToDateHint((String)matcher.group());
            }
            return DateValue.assertParsable(matcher.group(), () -> LocalDate.of(year, Integer.parseInt(month), DateValue.optInt(day)));
        }
        String week = matcher.group(WEEK);
        if (week != null) {
            return DateValue.assertParsable(matcher.group(), () -> DateValue.localWeekDate(year, Integer.parseInt(week), DateValue.optInt(matcher.group(DOW))));
        }
        String quarter = matcher.group(QUARTER);
        if (quarter != null) {
            return DateValue.assertParsable(matcher.group(), () -> DateValue.localQuarterDate(year, Integer.parseInt(quarter), DateValue.optInt(matcher.group(DOQ))));
        }
        String doy = matcher.group(DOY);
        if (doy != null) {
            return DateValue.assertParsable(matcher.group(), () -> LocalDate.ofYearDay(year, Integer.parseInt(doy)));
        }
        return DateValue.assertParsable(matcher.group(), () -> LocalDate.of(year, 1, 1));
    }

    private static DateValue parse(Matcher matcher) {
        return new DateValue(DateValue.parseDate(matcher));
    }

    private static int optInt(String value) {
        return value == null ? 1 : Integer.parseInt(value);
    }

    private static LocalDate localWeekDate(int year, int week, int dayOfWeek) {
        LocalDate weekOne = LocalDate.of(year, 1, 4);
        LocalDate withWeek = weekOne.with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, week);
        if (week == 53 && withWeek.get(IsoFields.WEEK_BASED_YEAR) != year) {
            throw InvalidArgumentException.tooManyWeeksThisYear((int)week, (int)year);
        }
        return withWeek.with(ChronoField.DAY_OF_WEEK, dayOfWeek);
    }

    private static LocalDate localQuarterDate(int year, int quarter, int dayOfQuarter) {
        if (quarter == 2 && dayOfQuarter == 92) {
            throw InvalidArgumentException.only91DaysInQuarter2((int)year, (int)dayOfQuarter);
        }
        LocalDate yearDate = LocalDate.ofYearDay(year, dayOfQuarter);
        if (!(quarter != 1 || dayOfQuarter <= 90 || yearDate.isLeapYear() && dayOfQuarter != 92)) {
            int dayLimit = yearDate.isLeapYear() ? 91 : 90;
            throw InvalidArgumentException.only90Or91DaysInQuarter1((int)year, (int)dayOfQuarter, (int)dayLimit);
        }
        return yearDate.with(IsoFields.QUARTER_OF_YEAR, quarter).with(IsoFields.DAY_OF_QUARTER, dayOfQuarter);
    }

    public long estimatedHeapUsage() {
        return INSTANCE_SIZE;
    }

    private static class DateBuilder
    extends TemporalValue.Builder<DateValue> {
        @Override
        protected boolean supportsTimeZone() {
            return false;
        }

        @Override
        protected boolean supportsEpoch() {
            return false;
        }

        DateBuilder(Supplier<ZoneId> defaultZone) {
            super(defaultZone);
        }

        @Override
        protected final boolean supportsDate() {
            return true;
        }

        @Override
        protected final boolean supportsTime() {
            return false;
        }

        private static LocalDate getDateOf(AnyValue temporal) {
            String string;
            if (temporal instanceof TemporalValue) {
                TemporalValue v = (TemporalValue)temporal;
                return v.getDatePart();
            }
            if (temporal instanceof Value) {
                Value v = (Value)temporal;
                string = v.prettyPrint();
            } else {
                string = String.valueOf(temporal);
            }
            String prettyVal = string;
            throw InvalidArgumentException.cannotConstructTemporal((String)"date", (String)String.valueOf(temporal), (String)prettyVal);
        }

        @Override
        public DateValue buildInternal() {
            LocalDate result = this.fields.containsKey((Object)TemporalValue.TemporalFields.date) ? DateBuilder.getDateOf((AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.date)) : (this.fields.containsKey((Object)TemporalValue.TemporalFields.week) ? DEFAULT_CALENDER_DATE.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(TemporalValue.TemporalFields.year.name(), (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.year), TemporalValue.TemporalFields.year.defaultValue)).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L) : DEFAULT_CALENDER_DATE);
            result = this.assignAllFields(result);
            return DateValue.date(result);
        }

        static DateValue selectDate(AnyValue date) {
            if (date instanceof DateValue) {
                return (DateValue)date;
            }
            return DateValue.date(DateBuilder.getDateOf(date));
        }
    }
}

