/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.github.jamm.Unmetered;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class ListValue
extends VirtualValue
implements SequenceValue,
Iterable<AnyValue> {
    private static final long JAVA_LIST_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(JavaListListValue.class);
    private static final long LIST_SLICE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ListSlice.class);
    private static final long REVERSED_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReversedList.class);
    private static final long CONCAT_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConcatList.class);
    private static final long APPEND_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AppendList.class);
    private static final long PREPEND_LIST_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PrependList.class);

    public Value ternaryContains(AnyValue value) {
        Iterator iterator = this.iterator();
        boolean undefinedEquality = false;
        while (iterator.hasNext()) {
            AnyValue nextValue = (AnyValue)iterator.next();
            Equality equality = nextValue.ternaryEquals(value);
            if (equality == Equality.TRUE) {
                return BooleanValue.TRUE;
            }
            if (equality != Equality.UNDEFINED || undefinedEquality) continue;
            undefinedEquality = true;
        }
        return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
    }

    public abstract ValueRepresentation itemValueRepresentation();

    @Override
    public String getTypeName() {
        return "List";
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getTypeName()).append('{');
        int i = 0;
        while ((long)i < this.actualSize() - 1L) {
            sb.append(this.value(i));
            sb.append(", ");
            ++i;
        }
        if (this.actualSize() > 0L) {
            sb.append(this.value(i));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isSequenceValue() {
        return true;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapSequence(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        return other != null && other.isSequenceValue() && this.equals((SequenceValue)((Object)other));
    }

    protected Iterator<AnyValue> randomAccessIterator() {
        long size = this.actualSize();
        if (size <= Integer.MAX_VALUE) {
            return new IntRandomAccessIterator(this, (int)size);
        }
        return new LongRandomAccessIterator(this, size);
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int intSize() {
        try {
            return Numbers.safeCastLongToInt((long)this.actualSize());
        }
        catch (java.lang.ArithmeticException e) {
            throw new ArithmeticException("numeric value out of range", (Throwable)e);
        }
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        ListValue otherList = (ListValue)other;
        return this.compareToSequence(otherList, comparator);
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        ListValue otherList = (ListValue)other;
        return this.ternaryCompareToSequence(otherList, comparator);
    }

    public AnyValue[] asArray() {
        return switch (this.iterationPreference()) {
            default -> throw new MatchException(null, null);
            case SequenceValue.IterationPreference.RANDOM_ACCESS -> this.randomAccessAsArray();
            case SequenceValue.IterationPreference.ITERATION -> this.iterationAsArray();
        };
    }

    @Override
    protected int computeHashToMemoize() {
        return switch (this.iterationPreference()) {
            default -> throw new MatchException(null, null);
            case SequenceValue.IterationPreference.RANDOM_ACCESS -> this.randomAccessComputeHash();
            case SequenceValue.IterationPreference.ITERATION -> this.iterationComputeHash();
        };
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        switch (this.iterationPreference()) {
            case RANDOM_ACCESS: {
                this.randomAccessWriteTo(writer);
                break;
            }
            case ITERATION: {
                this.iterationWriteTo(writer);
            }
        }
    }

    public ListValue slice(int from, int to) {
        int t;
        int f = Math.max(from, 0);
        if (f > (t = Math.min(to, this.intSize()))) {
            return VirtualValues.EMPTY_LIST;
        }
        return new ListSlice(this, f, t);
    }

    public ListValue tail() {
        return this.slice(1, this.intSize());
    }

    public ListValue drop(long n) {
        long size = this.actualSize();
        long start = Math.max(0L, Math.min(n, size));
        return new ListSlice(this, start, size);
    }

    public ListValue take(int n) {
        long end = Math.max(0L, Math.min((long)n, this.actualSize()));
        return new ListSlice(this, 0L, end);
    }

    public ListValue reverse() {
        return new ReversedList(this);
    }

    public AppendList append(AnyValue value) {
        return new AppendList(this, value);
    }

    public ListValue prepend(AnyValue value) {
        return new PrependList(this, value);
    }

    public ListValue appendAll(ListValue value) {
        return new ConcatList(new ListValue[]{this, value});
    }

    public ListValue distinct() {
        long keptValuesHeapSize = 0L;
        HashSet<AnyValue> seen = new HashSet<AnyValue>();
        ArrayList<AnyValue> kept = new ArrayList<AnyValue>();
        ValueRepresentation representation = ValueRepresentation.ANYTHING;
        for (AnyValue value : this) {
            if (seen.add(value)) {
                kept.add(value);
                keptValuesHeapSize += value.estimatedHeapUsage();
            }
            representation = representation.coerce(value.valueRepresentation());
        }
        return new JavaListListValue(kept, keptValuesHeapSize, representation);
    }

    public ArrayValue toStorableArray() {
        if (this.isEmpty()) {
            return Values.EMPTY_TEXT_ARRAY;
        }
        return this.itemValueRepresentation().arrayOf(this);
    }

    private AnyValue[] iterationAsArray() {
        ArrayList<AnyValue> values = new ArrayList<AnyValue>();
        int size = 0;
        for (AnyValue value : this) {
            values.add(value);
            ++size;
        }
        return values.toArray(new AnyValue[size]);
    }

    private AnyValue[] randomAccessAsArray() {
        int size = this.intSize();
        AnyValue[] values = new AnyValue[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.value(i);
        }
        return values;
    }

    private int randomAccessComputeHash() {
        int hashCode = 1;
        int size = this.intSize();
        for (int i = 0; i < size; ++i) {
            hashCode = 31 * hashCode + this.value(i).hashCode();
        }
        return hashCode;
    }

    private int iterationComputeHash() {
        int hashCode = 1;
        for (AnyValue value : this) {
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    private <E extends Exception> void randomAccessWriteTo(AnyValueWriter<E> writer) throws E {
        int size = this.intSize();
        writer.beginList(size);
        for (int i = 0; i < size; ++i) {
            this.value(i).writeTo(writer);
        }
        writer.endList();
    }

    private <E extends Exception> void iterationWriteTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.intSize());
        for (AnyValue value : this) {
            value.writeTo(writer);
        }
        writer.endList();
    }

    private static class IntRandomAccessIterator
    implements Iterator<AnyValue> {
        private final ListValue listValue;
        private final int actualSize;
        private long count;

        private IntRandomAccessIterator(ListValue listValue, int actualSize) {
            this.listValue = listValue;
            this.actualSize = actualSize;
        }

        @Override
        public boolean hasNext() {
            return this.count < (long)this.actualSize;
        }

        @Override
        public AnyValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.listValue.value(this.count++);
        }
    }

    private static class LongRandomAccessIterator
    implements Iterator<AnyValue> {
        private final ListValue listValue;
        private final long actualSize;
        private long count;

        private LongRandomAccessIterator(ListValue listValue, long actualSize) {
            this.listValue = listValue;
            this.actualSize = actualSize;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.actualSize;
        }

        @Override
        public AnyValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.listValue.value(this.count++);
        }
    }

    static final class ListSlice
    extends ListValue {
        private final ListValue inner;
        private final long from;
        private final long to;

        ListSlice(ListValue inner, long from, long to) {
            assert (from >= 0L);
            assert (to <= inner.actualSize());
            assert (from <= to);
            this.inner = inner;
            this.from = from;
            this.to = to;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public long actualSize() {
            return this.to - this.from;
        }

        @Override
        public AnyValue value(long offset) {
            return this.inner.value(offset + this.from);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return switch (this.inner.iterationPreference()) {
                default -> throw new MatchException(null, null);
                case SequenceValue.IterationPreference.RANDOM_ACCESS -> this.randomAccessIterator();
                case SequenceValue.IterationPreference.ITERATION -> new ListSliceIterator();
            };
        }

        public long estimatedHeapUsage() {
            return LIST_SLICE_SHALLOW_SIZE + this.inner.estimatedHeapUsage();
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.inner.itemValueRepresentation();
        }

        private class ListSliceIterator
        extends PrefetchingIterator<AnyValue> {
            private int count;
            private final Iterator<AnyValue> innerIterator;

            private ListSliceIterator() {
                this.innerIterator = ListSlice.this.inner.iterator();
            }

            protected AnyValue fetchNextOrNull() {
                while ((long)this.count < ListSlice.this.from && this.innerIterator.hasNext()) {
                    this.innerIterator.next();
                    ++this.count;
                }
                if ((long)this.count < ListSlice.this.from || (long)this.count >= ListSlice.this.to || !this.innerIterator.hasNext()) {
                    return null;
                }
                ++this.count;
                return this.innerIterator.next();
            }
        }
    }

    static final class ReversedList
    extends ListValue {
        private final ListValue inner;

        ReversedList(ListValue inner) {
            this.inner = inner;
        }

        @Override
        public ListValue reverse() {
            return this.inner;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.inner.iterationPreference();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.randomAccessIterator();
        }

        @Override
        public long actualSize() {
            return this.inner.actualSize();
        }

        @Override
        public boolean isEmpty() {
            return this.inner.isEmpty();
        }

        @Override
        public Value ternaryContains(AnyValue value) {
            return this.inner.ternaryContains(value);
        }

        @Override
        public AnyValue value(long offset) {
            return this.inner.value(this.actualSize() - 1L - offset);
        }

        public long estimatedHeapUsage() {
            return REVERSED_LIST_SHALLOW_SIZE + this.inner.estimatedHeapUsage();
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.inner.itemValueRepresentation();
        }
    }

    public static final class AppendList
    extends ListValue {
        private final ListValue base;
        private final AnyValue appended;
        private long size;
        private volatile long memoizedEstimatedHeapUsage;
        private static final long NOT_MEMOIZED = -1L;

        AppendList(ListValue base, AnyValue appended) {
            this.base = base;
            this.appended = appended;
            this.size = -1L;
            this.memoizedEstimatedHeapUsage = -1L;
        }

        @Override
        public ArrayValue toStorableArray() {
            ArrayValue array;
            if (this.base instanceof ArrayValueListValue && (array = ((ArrayValueListValue)this.base).array).hasCompatibleType(this.appended)) {
                return array.copyWithAppended(this.appended);
            }
            return super.toStorableArray();
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public long actualSize() {
            if (this.size == -1L) {
                this.size = this.base.actualSize() + 1L;
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Value ternaryContains(AnyValue value) {
            boolean undefinedEquality = false;
            ListValue baseList = this;
            while (baseList instanceof AppendList) {
                AppendList appendList = baseList;
                Equality baseEquality = appendList.appended.ternaryEquals(value);
                if (baseEquality == Equality.TRUE) {
                    return BooleanValue.TRUE;
                }
                if (baseEquality == Equality.UNDEFINED && !undefinedEquality) {
                    undefinedEquality = true;
                }
                baseList = appendList.base;
            }
            Value baseContains = ((ListValue)baseList).ternaryContains(value);
            if (baseContains == BooleanValue.FALSE) {
                return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
            }
            return baseContains;
        }

        @Override
        public AnyValue value(long offset) {
            long size = this.base.actualSize();
            if (offset < size) {
                return this.base.value(offset);
            }
            if (offset < size + 1L) {
                return this.appended;
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + size);
        }

        @Override
        public void forEach(Consumer<? super AnyValue> consumer) {
            this.base.forEach(consumer);
            consumer.accept(this.appended);
        }

        @Override
        public AnyValue last() {
            return this.appended;
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return switch (this.base.iterationPreference()) {
                default -> throw new MatchException(null, null);
                case SequenceValue.IterationPreference.RANDOM_ACCESS -> this.randomAccessIterator();
                case SequenceValue.IterationPreference.ITERATION -> Iterators.appendTo((Iterator)this.base.iterator(), (Object[])new AnyValue[]{this.appended});
            };
        }

        public long estimatedHeapUsage() {
            long tmp = this.memoizedEstimatedHeapUsage;
            if (tmp == -1L) {
                this.memoizedEstimatedHeapUsage = tmp = APPEND_LIST_SHALLOW_SIZE + this.base.estimatedHeapUsage() + this.appended.estimatedHeapUsage();
            }
            return tmp;
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            if (this.base.isEmpty()) {
                return this.appended.valueRepresentation();
            }
            return this.base.itemValueRepresentation().coerce(this.appended.valueRepresentation());
        }
    }

    static final class PrependList
    extends ListValue {
        private final ListValue base;
        private final AnyValue prepended;
        private volatile long size;
        private volatile long memoizedEstimatedHeapUsage;
        private static final long NOT_MEMOIZED = -1L;

        PrependList(ListValue base, AnyValue prepended) {
            this.base = base;
            this.prepended = prepended;
            this.size = -1L;
            this.memoizedEstimatedHeapUsage = -1L;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.base.iterationPreference();
        }

        @Override
        public long actualSize() {
            if (this.size == -1L) {
                this.size = this.base.actualSize() + 1L;
            }
            return this.size;
        }

        @Override
        public void forEach(Consumer<? super AnyValue> consumer) {
            consumer.accept(this.prepended);
            ListValue baseList = this.base;
            while (baseList instanceof PrependList) {
                PrependList prependList = (PrependList)baseList;
                consumer.accept(prependList.prepended);
                baseList = prependList.base;
            }
            baseList.forEach(consumer);
        }

        @Override
        public Value ternaryContains(AnyValue value) {
            boolean undefinedEquality = false;
            ListValue baseList = this;
            while (baseList instanceof PrependList) {
                PrependList prependList = baseList;
                Equality baseEquality = prependList.prepended.ternaryEquals(value);
                if (baseEquality == Equality.TRUE) {
                    return BooleanValue.TRUE;
                }
                if (baseEquality == Equality.UNDEFINED && !undefinedEquality) {
                    undefinedEquality = true;
                }
                baseList = prependList.base;
            }
            Value baseContains = ((ListValue)baseList).ternaryContains(value);
            if (baseContains == BooleanValue.FALSE) {
                return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
            }
            return baseContains;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public AnyValue value(long offset) {
            if (offset == 0L) {
                return this.prepended;
            }
            if (offset < this.base.actualSize() + 1L) {
                return this.base.value(offset - 1L);
            }
            throw new IndexOutOfBoundsException(offset + " is outside range " + this.size);
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return switch (this.base.iterationPreference()) {
                default -> throw new MatchException(null, null);
                case SequenceValue.IterationPreference.RANDOM_ACCESS -> this.randomAccessIterator();
                case SequenceValue.IterationPreference.ITERATION -> Iterators.prependTo((Iterator)this.base.iterator(), (Object[])new AnyValue[]{this.prepended});
            };
        }

        public long estimatedHeapUsage() {
            long tmp = this.memoizedEstimatedHeapUsage;
            if (tmp == -1L) {
                this.memoizedEstimatedHeapUsage = tmp = PREPEND_LIST_SHALLOW_SIZE + this.base.estimatedHeapUsage() + this.prepended.estimatedHeapUsage();
            }
            return tmp;
        }

        @Override
        public ArrayValue toStorableArray() {
            ArrayValue array;
            if (this.base instanceof ArrayValueListValue && (array = ((ArrayValueListValue)this.base).array).hasCompatibleType(this.prepended)) {
                return array.copyWithPrepended(this.prepended);
            }
            return super.toStorableArray();
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            if (this.base.isEmpty()) {
                return this.prepended.valueRepresentation();
            }
            return this.base.itemValueRepresentation().coerce(this.prepended.valueRepresentation());
        }
    }

    static final class ConcatList
    extends ListValue {
        private final ListValue[] lists;
        private final ValueRepresentation itemValueRepresentation;
        private volatile long size = -1L;
        private final SequenceValue.IterationPreference iterationPreference;

        ConcatList(ListValue[] lists) {
            ValueRepresentation representation = ValueRepresentation.ANYTHING;
            SequenceValue.IterationPreference pref = lists.length < 10 ? SequenceValue.IterationPreference.RANDOM_ACCESS : SequenceValue.IterationPreference.ITERATION;
            for (ListValue list : lists) {
                representation = representation.coerce(list.itemValueRepresentation());
                if (list.iterationPreference() != SequenceValue.IterationPreference.ITERATION) continue;
                pref = SequenceValue.IterationPreference.ITERATION;
            }
            this.iterationPreference = pref;
            this.itemValueRepresentation = representation;
            this.lists = lists;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return this.iterationPreference;
        }

        @Override
        public Iterator<AnyValue> iterator() {
            if (this.iterationPreference == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                return this.randomAccessIterator();
            }
            return new ConcatListIterator();
        }

        @Override
        public long actualSize() {
            if (this.size < 0L) {
                long s = 0L;
                for (ListValue list : this.lists) {
                    s += list.actualSize();
                }
                this.size = s;
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            for (ListValue list : this.lists) {
                if (list.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public AnyValue value(long offset) {
            for (ListValue list : this.lists) {
                long size = list.actualSize();
                if (offset < size) {
                    return list.value(offset);
                }
                offset -= size;
            }
            throw new IndexOutOfBoundsException();
        }

        public long estimatedHeapUsage() {
            long s = 0L;
            for (ListValue list : this.lists) {
                s += list.estimatedHeapUsage();
            }
            return CONCAT_LIST_SHALLOW_SIZE + s;
        }

        @Override
        public ListValue appendAll(ListValue value) {
            int newSize = this.lists.length + 1;
            ListValue[] newArray = new ListValue[newSize];
            System.arraycopy(this.lists, 0, newArray, 0, this.lists.length);
            newArray[this.lists.length] = value;
            return new ConcatList(newArray);
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.itemValueRepresentation;
        }

        private final class ConcatListIterator
        extends PrefetchingIterator<AnyValue> {
            private int index = 1;
            private Iterator<AnyValue> inner;

            private ConcatListIterator() {
                this.inner = ConcatList.this.lists[0].iterator();
            }

            protected AnyValue fetchNextOrNull() {
                while (true) {
                    if (this.inner.hasNext()) {
                        return this.inner.next();
                    }
                    if (this.index >= ConcatList.this.lists.length) break;
                    this.inner = ConcatList.this.lists[this.index++].iterator();
                }
                return null;
            }
        }
    }

    static final class JavaListListValue
    extends ListValue {
        private final List<AnyValue> values;
        private final long payloadSize;
        @Unmetered
        private final ValueRepresentation itemRepresentation;

        JavaListListValue(List<AnyValue> values, long payloadSize, ValueRepresentation itemRepresentation) {
            assert (payloadSize >= 0L && values != null && !ArrayHelpers.containsNull(values) && ArrayHelpers.assertValueRepresentation((AnyValue[])values.toArray(AnyValue[]::new), itemRepresentation));
            this.payloadSize = payloadSize;
            this.values = values;
            this.itemRepresentation = itemRepresentation;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            if (this.values instanceof ArrayList) {
                return SequenceValue.IterationPreference.RANDOM_ACCESS;
            }
            return SequenceValue.IterationPreference.ITERATION;
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public long actualSize() {
            return this.values.size();
        }

        @Override
        public Value ternaryContains(AnyValue value) {
            if (this.values.isEmpty()) {
                return BooleanValue.FALSE;
            }
            boolean undefinedEquality = false;
            for (AnyValue nextValue : this.values) {
                Equality equality = nextValue.ternaryEquals(value);
                if (equality == Equality.TRUE) {
                    return BooleanValue.TRUE;
                }
                if (equality != Equality.UNDEFINED || undefinedEquality) continue;
                undefinedEquality = true;
            }
            return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
        }

        @Override
        public AnyValue value(long offset) {
            Objects.checkIndex(0, this.values.size());
            return this.values.get((int)offset);
        }

        @Override
        public AnyValue[] asArray() {
            return this.values.toArray(new AnyValue[0]);
        }

        @Override
        protected int computeHashToMemoize() {
            return this.values.hashCode();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.values.iterator();
        }

        public long estimatedHeapUsage() {
            return JAVA_LIST_LIST_VALUE_SHALLOW_SIZE + this.payloadSize;
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.itemRepresentation;
        }
    }

    public static final class ArrayListValue
    extends ListValue {
        private static final long ARRAY_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ArrayListValue.class);
        private final AnyValue[] values;
        private final long payloadSize;
        @Unmetered
        private final ValueRepresentation itemRepresentation;

        ArrayListValue(AnyValue[] values, long payloadSize, ValueRepresentation itemRepresentation) {
            assert (values != null && payloadSize >= 0L && !ArrayHelpers.containsNull(values) && ArrayHelpers.assertValueRepresentation(values, itemRepresentation));
            this.payloadSize = HeapEstimator.shallowSizeOfObjectArray((int)values.length) + payloadSize;
            this.values = values;
            this.itemRepresentation = itemRepresentation;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return Iterators.iterator((Object[])this.values);
        }

        @Override
        public long actualSize() {
            return this.intSize();
        }

        @Override
        public int intSize() {
            return this.values.length;
        }

        @Override
        public AnyValue value(long offset) {
            Objects.checkIndex(0, this.values.length);
            return this.values[(int)offset];
        }

        @Override
        public AnyValue[] asArray() {
            return this.values;
        }

        @Override
        protected int computeHashToMemoize() {
            return Arrays.hashCode(this.values);
        }

        public long estimatedHeapUsage() {
            return ARRAY_LIST_VALUE_SHALLOW_SIZE + this.payloadSize;
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.itemRepresentation;
        }

        @Override
        public Value ternaryContains(AnyValue value) {
            if (this.values.length == 0) {
                return BooleanValue.FALSE;
            }
            boolean undefinedEquality = false;
            for (AnyValue nextValue : this.values) {
                Equality equality = nextValue.ternaryEquals(value);
                if (equality == Equality.TRUE) {
                    return BooleanValue.TRUE;
                }
                if (equality != Equality.UNDEFINED || undefinedEquality) continue;
                undefinedEquality = true;
            }
            return undefinedEquality ? Values.NO_VALUE : BooleanValue.FALSE;
        }
    }

    public static final class RelationshipListValue
    extends ListValue {
        private static final long REL_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipListValue.class);
        private final List<VirtualRelationshipValue> list;

        RelationshipListValue(List<VirtualRelationshipValue> list) {
            this.list = list;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public ArrayValue toStorableArray() {
            throw CypherTypeException.propertyWithRelCollection(this.list);
        }

        @Override
        public long actualSize() {
            return this.intSize();
        }

        @Override
        public int intSize() {
            return this.list.size();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return Iterators.map(Function.identity(), this.list.iterator());
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return ValueRepresentation.ANYTHING;
        }

        @Override
        public AnyValue value(long offset) {
            Objects.checkIndex(0, this.list.size());
            return this.list.get((int)offset);
        }

        public long estimatedHeapUsage() {
            int length = this.list.size();
            if (length == 0) {
                return REL_LIST_VALUE_SHALLOW_SIZE;
            }
            return REL_LIST_VALUE_SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)HeapEstimator.sizeOf((Object)this.list.get(0)), (int)length);
        }
    }

    public static final class ArrayValueListValue
    extends ListValue {
        private static final long ARRAY_VALUE_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ArrayValueListValue.class);
        private final ArrayValue array;

        ArrayValueListValue(ArrayValue array) {
            this.array = array;
        }

        @Override
        public SequenceValue.IterationPreference iterationPreference() {
            return SequenceValue.IterationPreference.RANDOM_ACCESS;
        }

        @Override
        public ArrayValue toStorableArray() {
            return this.array;
        }

        @Override
        public long actualSize() {
            return this.array.intSize();
        }

        @Override
        public int intSize() {
            return this.array.intSize();
        }

        @Override
        public Iterator<AnyValue> iterator() {
            return this.array.iterator();
        }

        @Override
        public ValueRepresentation itemValueRepresentation() {
            return this.isEmpty() ? ValueRepresentation.ANYTHING : this.head().valueRepresentation();
        }

        @Override
        public AnyValue value(long offset) {
            return this.array.value(offset);
        }

        @Override
        protected int computeHashToMemoize() {
            return this.array.hashCode();
        }

        public long estimatedHeapUsage() {
            return ARRAY_VALUE_LIST_VALUE_SHALLOW_SIZE + this.array.estimatedHeapUsage();
        }
    }
}

