/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Locale;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum PointFields {
    X("x"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(0, this.propertyKey, false);
        }
    }
    ,
    Y("y"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(1, this.propertyKey, false);
        }
    }
    ,
    Z("z"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(2, this.propertyKey, false);
        }
    }
    ,
    LONGITUDE("longitude"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(0, this.propertyKey, true);
        }
    }
    ,
    LATITUDE("latitude"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(1, this.propertyKey, true);
        }
    }
    ,
    HEIGHT("height"){

        @Override
        Value get(PointValue value) {
            return value.getNthCoordinate(2, this.propertyKey, true);
        }
    }
    ,
    CRS("crs"){

        @Override
        Value get(PointValue value) {
            return Values.stringValue(value.getCoordinateReferenceSystem().toString());
        }
    }
    ,
    SRID("srid"){

        @Override
        Value get(PointValue value) {
            return Values.intValue(value.getCoordinateReferenceSystem().getCode());
        }
    };

    public final String propertyKey;

    private PointFields(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public static PointFields fromName(String fieldName) {
        switch (fieldName.toLowerCase(Locale.ROOT)) {
            case "x": {
                return X;
            }
            case "y": {
                return Y;
            }
            case "z": {
                return Z;
            }
            case "longitude": {
                return LONGITUDE;
            }
            case "latitude": {
                return LATITUDE;
            }
            case "height": {
                return HEIGHT;
            }
            case "crs": {
                return CRS;
            }
            case "srid": {
                return SRID;
            }
        }
        throw InvalidArgumentException.noSuchPointField((String)fieldName);
    }

    abstract Value get(PointValue var1);
}

