/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class DoubleArray
extends FloatingPointArray {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DoubleArray.class);
    private final double[] value;

    DoubleArray(double[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int intSize() {
        return this.value.length;
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof FloatingPointValue;
    }

    @Override
    public float floatValue(int index) {
        return (float)this.value[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public DoubleValue value(int position) {
        return Values.doubleValue(this.doubleValue(position));
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDoubleArray(this);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(double[] x) {
        return Arrays.equals(x, this.value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public double[] asObjectCopy() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Deprecated
    public double[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "DoubleArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((double[])this.value);
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        double[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((FloatingPointValue)added).doubleValue();
        return new DoubleArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        double[] newArray = new double[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((FloatingPointValue)prepended).doubleValue();
        return new DoubleArray(newArray);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.FLOAT64_ARRAY;
    }
}

