/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util.helpers;

import java.io.Serializable;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator$;
import org.neo4j.cypher.internal.util.Rewriter$;
import org.neo4j.cypher.internal.util.helpers.fixedPoint$;
import org.neo4j.cypher.internal.util.topDown$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.matching.Regex;

public final class NameDeduplicator$ {
    public static final NameDeduplicator$ MODULE$ = new NameDeduplicator$();
    private static final Regex UNNAMED_PATTERN = MODULE$.nameGeneratorRegex(AnonymousVariableNameGenerator$.MODULE$.generatorName());
    private static final Regex UNNAMED_PARAMS_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(" {2}(AUTOINT|AUTODOUBLE|AUTOSTRING|AUTOLIST)(\\d+)"));
    private static final Regex DEDUP_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(" {2}([^\\s]+)@\\d+(?:\\(.*?\\))?"));
    private static final Function1<String, String> deduplicateVariableNames = fixedPoint$.MODULE$.apply((Function1 & Serializable)x$1 -> MODULE$.DEDUP_PATTERN().replaceAllIn((CharSequence)x$1, "$1"));

    public Regex nameGeneratorRegex(String generatorName) {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(" {2}(" + generatorName + ")(\\d+)"));
    }

    public Regex UNNAMED_PATTERN() {
        return UNNAMED_PATTERN;
    }

    private Regex UNNAMED_PARAMS_PATTERN() {
        return UNNAMED_PARAMS_PATTERN;
    }

    private Regex DEDUP_PATTERN() {
        return DEDUP_PATTERN;
    }

    private Function1<Object, Object> transformGeneratedNamesRewriter(Function1<String, String> transformation) {
        return topDown$.MODULE$.apply(Rewriter$.MODULE$.lift((PartialFunction<Object, Object>)new Serializable(transformation){
            private static final long serialVersionUID = 0L;
            private final Function1 transformation$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof String) {
                    String string = (String)A1;
                    return (B1)this.transformation$1.apply((Object)string);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof String;
            }
            {
                this.transformation$1 = transformation$1;
            }
        }), topDown$.MODULE$.apply$default$2(), topDown$.MODULE$.apply$default$3(), topDown$.MODULE$.apply$default$4());
    }

    private Function1<String, String> deduplicateVariableNames() {
        return deduplicateVariableNames;
    }

    public String removeGeneratedNamesAndParams(String s) {
        String paramNamed = this.UNNAMED_PARAMS_PATTERN().replaceAllIn((CharSequence)s, (Function1 & Serializable)m -> m.group(1).toLowerCase() + "_" + m.group(2));
        String named = this.UNNAMED_PATTERN().replaceAllIn((CharSequence)paramNamed, (Function1 & Serializable)m -> "anon_" + m.group(2));
        return (String)this.deduplicateVariableNames().apply((Object)named);
    }

    public String eraseGeneratedNames(String s) {
        return this.UNNAMED_PATTERN().replaceAllIn((CharSequence)s, "");
    }

    public <M> M removeGeneratedNamesAndParamsOnTree(M a) {
        return (M)this.transformGeneratedNamesRewriter((Function1<String, String>)(Function1 & Serializable)s -> MODULE$.removeGeneratedNamesAndParams((String)s)).apply(a);
    }

    public <M> M eraseGeneratedNamesOnTree(M a) {
        return (M)this.transformGeneratedNamesRewriter((Function1<String, String>)(Function1 & Serializable)s -> MODULE$.eraseGeneratedNames((String)s)).apply(a);
    }

    private NameDeduplicator$() {
    }
}

