/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util;

import java.util.Arrays;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectMethod;
import scala.None;
import scala.Product;
import scala.Some;
import scala.util.Left;
import scala.util.Right;

@CompileTime
public class RewritableJavascript {
    static boolean isSubclassOf(ReflectClass<Object> cls, Class<?> other) {
        ReflectClass reflectClass = Metaprogramming.findClass(other);
        return reflectClass.isAssignableFrom(cls);
    }

    public static boolean inAllowList(ReflectClass<Object> cls) {
        return RewritableJavascript.isSubclassOf(cls, ASTNode.class) || RewritableJavascript.isSubclassOf(cls, Some.class) || RewritableJavascript.isSubclassOf(cls, None.class) || RewritableJavascript.isSubclassOf(cls, Left.class) || RewritableJavascript.isSubclassOf(cls, Right.class);
    }

    private static ReflectMethod getCopyConstructor(ReflectClass<Object> cls) {
        ReflectMethod method = Arrays.stream(cls.getMethods()).filter(m -> m.getName().equals("copy")).findFirst().orElse(null);
        return method;
    }

    public static Object copyProduct(Product product, Object[] children) {
        return RewritableJavascript.copyConstructor(product.getClass(), product, children);
    }

    public int numParameters(Product product) {
        return RewritableJavascript.numParameters(product.getClass());
    }

    public boolean includesPosition(Product product) {
        return RewritableJavascript.lastParamIsPosition(product.getClass());
    }

    @Meta
    public static native Object copyConstructor(Class<?> var0, Object var1, Object[] var2);

    public static void copyConstructor(ReflectClass<Object> cls, Value<Object> object, Value<Object[]> children) {
        if (!RewritableJavascript.inAllowList(cls)) {
            Metaprogramming.unsupportedCase();
            return;
        }
        ReflectMethod method = RewritableJavascript.getCopyConstructor(cls);
        if (method != null) {
            Value result = Metaprogramming.emit(() -> method.invoke(object.get(), (Object[])children.get()));
            Metaprogramming.exit(() -> result.get());
        } else {
            Metaprogramming.unsupportedCase();
        }
    }

    @Meta
    public static native int numParameters(Class<?> var0);

    public static void numParameters(ReflectClass<Object> cls) {
        if (!RewritableJavascript.inAllowList(cls)) {
            Metaprogramming.unsupportedCase();
            return;
        }
        ReflectMethod method = RewritableJavascript.getCopyConstructor(cls);
        if (method != null) {
            int result = method.getParameterTypes().length;
            Metaprogramming.exit(() -> result);
        } else {
            Metaprogramming.unsupportedCase();
        }
    }

    @Meta
    public static native boolean lastParamIsPosition(Class<?> var0);

    public static void lastParamIsPosition(ReflectClass<Object> cls) {
        if (!RewritableJavascript.inAllowList(cls)) {
            Metaprogramming.unsupportedCase();
            return;
        }
        ReflectMethod method = RewritableJavascript.getCopyConstructor(cls);
        if (method != null) {
            ReflectClass[] paramTypes = method.getParameterTypes();
            ReflectClass lastParam = paramTypes[paramTypes.length - 1];
            boolean result = lastParam.isAssignableFrom(InputPosition.class);
            Metaprogramming.exit(() -> result);
        } else {
            Metaprogramming.unsupportedCase();
        }
    }
}

