/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.NativeMemoryAllocationRefusedError;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public final class MemoryManager {
    private static final long GRAB_SIZE = FeatureToggles.getInteger(MemoryManager.class, "GRAB_SIZE", 524288);
    private long memoryReserve;
    private final long alignment;
    private Grab grabs;

    public MemoryManager(long expectedMaxMemory, long alignment) {
        if (alignment == 0L) {
            throw new IllegalArgumentException("Alignment cannot be zero");
        }
        this.memoryReserve = expectedMaxMemory;
        this.alignment = alignment;
    }

    public synchronized long sumUsedMemory() {
        long sum = 0L;
        Grab grab = this.grabs;
        while (grab != null) {
            sum += grab.nextAlignedPointer - grab.address;
            grab = grab.next;
        }
        return sum;
    }

    public synchronized long allocateAligned(long bytes) {
        if (bytes > GRAB_SIZE) {
            Grab nextGrab = this.grabs == null ? null : this.grabs.next;
            Grab allocationGrab = new Grab(nextGrab, bytes, this.alignment);
            if (!allocationGrab.canAllocate(bytes)) {
                allocationGrab.free();
                allocationGrab = new Grab(nextGrab, bytes + this.alignment, this.alignment);
            }
            long allocation = allocationGrab.allocate(bytes);
            this.grabs = this.grabs == null ? allocationGrab : this.grabs.setNext(allocationGrab);
            this.memoryReserve -= bytes;
            return allocation;
        }
        if (this.grabs == null || !this.grabs.canAllocate(bytes)) {
            long desiredGrabSize = Math.min(GRAB_SIZE, this.memoryReserve);
            if (desiredGrabSize < bytes) {
                desiredGrabSize = bytes;
                Grab grab = new Grab(this.grabs, desiredGrabSize, this.alignment);
                if (grab.canAllocate(bytes)) {
                    this.memoryReserve -= desiredGrabSize;
                    this.grabs = grab;
                    return this.grabs.allocate(bytes);
                }
                grab.free();
                desiredGrabSize = bytes + this.alignment;
            }
            this.memoryReserve -= desiredGrabSize;
            this.grabs = new Grab(this.grabs, desiredGrabSize, this.alignment);
        }
        return this.grabs.allocate(bytes);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        Grab current = this.grabs;
        while (current != null) {
            current.free();
            current = current.next;
        }
    }

    private static long allocateNativeMemory(long size) {
        try {
            return UnsafeUtil.allocateMemory(size);
        }
        catch (OutOfMemoryError e) {
            NativeMemoryAllocationRefusedError error = new NativeMemoryAllocationRefusedError(size);
            try {
                error.initCause(e);
            }
            catch (Throwable ignore) {
                try {
                    error.addSuppressed(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw error;
        }
    }

    private static class Grab {
        public final Grab next;
        private final long address;
        private final long limit;
        private final long alignment;
        private long nextAlignedPointer;

        Grab(Grab next, long size, long alignment) {
            this.next = next;
            this.address = MemoryManager.allocateNativeMemory(size);
            this.limit = this.address + size;
            this.alignment = alignment;
            this.nextAlignedPointer = this.nextAligned(this.address);
        }

        Grab(Grab next, long address, long limit, long alignment, long nextAlignedPointer) {
            this.next = next;
            this.address = address;
            this.limit = limit;
            this.alignment = alignment;
            this.nextAlignedPointer = nextAlignedPointer;
        }

        private long nextAligned(long pointer) {
            if (this.alignment == 1L) {
                return pointer;
            }
            long off = pointer % this.alignment;
            if (off == 0L) {
                return pointer;
            }
            return pointer + (this.alignment - off);
        }

        long allocate(long bytes) {
            long allocation = this.nextAlignedPointer;
            this.nextAlignedPointer = this.nextAligned(this.nextAlignedPointer + bytes);
            return allocation;
        }

        void free() {
            UnsafeUtil.free(this.address);
        }

        boolean canAllocate(long bytes) {
            return this.nextAlignedPointer + bytes <= this.limit;
        }

        Grab setNext(Grab grab) {
            return new Grab(grab, this.address, this.limit, this.alignment, this.nextAlignedPointer);
        }

        public String toString() {
            long size = this.limit - this.address;
            long reserve = this.nextAlignedPointer > this.limit ? 0L : this.limit - this.nextAlignedPointer;
            double use = (1.0 - (double)reserve / (double)size) * 100.0;
            return String.format("Grab[size = %d bytes, reserve = %d bytes, use = %5.2f %%]", size, reserve, use);
        }
    }
}

