/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.udc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.api.database.DatabaseSizeService;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;
import org.neo4j.udc.UserDataCollectorSource;

public class UserDataCollector
extends LifecycleAdapter {
    private static final URI UDC_URI = URI.create("https://udc.neo4j.com/server");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String CLUSTER_SIZE_KEY = "clusterSize";
    private final Config config;
    private final Edition edition;
    private final FileSystemAbstraction fs;
    private final Map<String, String> data = new HashMap<String, String>();
    private final Collection<UserDataCollectorSource> additionalData;
    private final DatabaseManagementService databaseManagementService;
    private final JobScheduler jobScheduler;
    private final Log userLog;
    private final InternalLog log;
    private final boolean networkEnabled;
    private long counter;
    private JobHandle<?> jobHandle;

    public UserDataCollector(Config config, DatabaseManagementService databaseManagementService, DbmsInfo dbmsInfo, JobScheduler jobScheduler, LogProvider logProvider, InternalLogProvider internalLogProvider, FileSystemAbstraction fs) {
        this.config = config;
        this.databaseManagementService = databaseManagementService;
        this.jobScheduler = jobScheduler;
        this.userLog = logProvider.getLog(UserDataCollector.class);
        this.log = internalLogProvider.getLog(UserDataCollector.class);
        this.edition = dbmsInfo.edition;
        this.fs = fs;
        this.networkEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.udc_network_enabled);
        this.data.put("edition", dbmsInfo.edition.toString().toLowerCase(Locale.ROOT));
        this.data.put("numberOfProcessors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.data.put("totalMemory", String.valueOf(OsBeanUtil.getTotalPhysicalMemory()));
        this.data.put("totalHeap", String.valueOf(Runtime.getRuntime().maxMemory()));
        this.data.put("version", Version.getNeo4jVersion());
        this.data.put("packaging", UserDataCollector.getPackagingInformation(config, fs));
        this.data.put(CLUSTER_SIZE_KEY, String.valueOf(1));
        this.additionalData = Services.loadAll(UserDataCollectorSource.class);
    }

    public void ping() {
        this.data.put("counter", String.valueOf(++this.counter));
        GraphDatabaseAPI systemDatabase = (GraphDatabaseAPI)this.databaseManagementService.database("system");
        StoreIdProvider storeIdProvider = (StoreIdProvider)systemDatabase.getDependencyResolver().resolveDependency(StoreIdProvider.class);
        this.data.put("uuid", StoreIdDecodeUtils.decodeId((ExternalStoreId)storeIdProvider.getExternalStoreId()));
        this.data.putAll(this.getDatabaseEntityCount());
        for (UserDataCollectorSource source : this.additionalData) {
            try {
                this.data.putAll(source.getData(this.databaseManagementService, this.fs, this.config, this.log));
            }
            catch (Exception e) {
                this.log.debug("Failed to collect data from source " + source.getClass().getName(), (Throwable)e);
            }
        }
        try {
            HttpRequest request;
            HttpResponse<String> response;
            HttpClient httpClient = HttpClient.newHttpClient();
            String jsonPayload = OBJECT_MAPPER.writeValueAsString(this.data);
            this.log.debug("Sending anonymous user data '%s'", new Object[]{jsonPayload});
            if (this.networkEnabled && (response = httpClient.send(request = HttpRequest.newBuilder().uri(UDC_URI).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
                this.log.debug(String.valueOf(UDC_URI) + " responded with " + response.statusCode());
            }
        }
        catch (Exception e) {
            this.log.debug("Unable to send data to " + String.valueOf(UDC_URI), (Throwable)e);
        }
    }

    public void start() {
        if (this.edition != Edition.COMMUNITY && this.edition != Edition.ENTERPRISE) {
            return;
        }
        if (!((Boolean)this.config.get(GraphDatabaseSettings.udc_enabled)).booleanValue()) {
            return;
        }
        this.userLog.info("Anonymous Usage Data is being sent to Neo4j, see https://neo4j.com/docs/usage-data/");
        this.jobHandle = this.jobScheduler.scheduleRecurring(Group.UDC, this::ping, ((Long)this.config.get(GraphDatabaseInternalSettings.udc_initial_delay_ms)).longValue(), ((Long)this.config.get(GraphDatabaseInternalSettings.udc_report_interval_ms)).longValue(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.jobHandle != null) {
            this.jobHandle.cancel();
        }
    }

    private Map<String, String> getDatabaseEntityCount() {
        GraphDatabaseAPI systemDatabase = (GraphDatabaseAPI)this.databaseManagementService.database("system");
        DatabaseSizeService databaseSizeService = (DatabaseSizeService)systemDatabase.getDependencyResolver().resolveDependency(DatabaseSizeService.class);
        List databases = this.databaseManagementService.listDatabases();
        long nodes = 0L;
        long relationships = 0L;
        long labels = 0L;
        long dataSize = 0L;
        int databaseCount = 0;
        for (String database : databases) {
            try {
                GraphDatabaseAPI db = (GraphDatabaseAPI)this.databaseManagementService.database(database);
                StorageEngine storageEngine = (StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class);
                StoreEntityCounters storeEntityCounters = storageEngine.storeEntityCounters();
                nodes += storeEntityCounters.estimateNodes();
                relationships += storeEntityCounters.estimateRelationships();
                labels += storeEntityCounters.estimateLabels();
                dataSize += databaseSizeService.getDatabaseDataSize(db.databaseId());
                if (db.databaseId().isSystemDatabase()) continue;
                ++databaseCount;
            }
            catch (Exception e) {
                this.log.debug("Failed to collect data from database " + database, (Throwable)e);
            }
        }
        return Map.of("nodes", String.valueOf(nodes), "relationships", String.valueOf(relationships), "labels", String.valueOf(labels), "storeSize", String.valueOf(dataSize), "databaseCount", String.valueOf(databaseCount));
    }

    private static String getPackagingInformation(Config config, FileSystemAbstraction fs) {
        Path packagingInfoFile = ((Path)config.get(GraphDatabaseSettings.neo4j_home)).resolve("packaging_info");
        try {
            List lines = FileSystemUtils.readLines((FileSystemAbstraction)fs, (Path)packagingInfoFile, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            for (String line : Objects.requireNonNull(lines)) {
                if (!line.startsWith("Package Type:")) continue;
                return line.substring("Package Type:".length()).trim();
            }
        }
        catch (Exception e) {
            return "error";
        }
        return "unknown";
    }
}

