/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Usage Data Collector configuration settings")
public class UdcSettings
implements LoadableConfig {
    @Description(value="Enable the UDC extension.")
    public static final Setting<Boolean> udc_enabled = Settings.setting((String)"dbms.udc.enabled", (Function)Enabled.UNLESS_EXPLICITLY_DISABLED, (String)Enabled.AS_DEFAULT_VALUE);
    @Internal
    public static final Setting<Integer> first_delay = Settings.buildSetting((String)"unsupported.dbms.udc.first_delay", (Function)Settings.INTEGER, (String)Integer.toString(600000)).constraint(Settings.min((Comparable)Integer.valueOf(1))).build();
    @Internal
    public static final Setting<Integer> interval = Settings.buildSetting((String)"unsupported.dbms.udc.interval", (Function)Settings.INTEGER, (String)Integer.toString(86400000)).constraint(Settings.min((Comparable)Integer.valueOf(1))).build();
    @Internal
    public static final Setting<HostnamePort> udc_host = Settings.setting((String)"unsupported.dbms.udc.host", (Function)Settings.HOSTNAME_PORT, (String)"udc.neo4j.org");
    @Internal
    public static final Setting<String> udc_source = Settings.buildSetting((String)"unsupported.dbms.udc.source", (Function)Settings.STRING, (String)"maven").constraint(Settings.illegalValueMessage((String)"Must be a valid source", (BiFunction)Settings.matches((String)".+"))).build();
    @Internal
    public static final Setting<String> udc_registration_key = Settings.buildSetting((String)"unsupported.dbms.udc.reg", (Function)Settings.STRING, (String)"unreg").constraint(Settings.illegalValueMessage((String)"Must be a valid registration id", (BiFunction)Settings.matches((String)".+"))).build();

    private static enum Enabled implements Function<String, Boolean>
    {
        UNLESS_EXPLICITLY_DISABLED;

        static final String AS_DEFAULT_VALUE;

        @Override
        public Boolean apply(String from) {
            if (from == AS_DEFAULT_VALUE) {
                String enabled = System.getProperty(udc_enabled.name());
                if ("false".equalsIgnoreCase(enabled)) {
                    String disabled = System.getProperty(Enabled.udc_disabled());
                    if (disabled == null || disabled.equalsIgnoreCase("true")) {
                        return Boolean.FALSE;
                    }
                } else if ("true".equalsIgnoreCase(System.getProperty(Enabled.udc_disabled()))) {
                    return enabled != null;
                }
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(from)) {
                String enabled = System.getProperty(udc_enabled.name());
                String disabled = System.getProperty(Enabled.udc_disabled());
                if ((enabled == null || enabled.equalsIgnoreCase("false")) && (disabled == null || disabled.equalsIgnoreCase("true"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return Boolean.TRUE;
        }

        public String toString() {
            return "a boolean";
        }

        private static String udc_disabled() {
            return udc_enabled.name().replace("enabled", "disable");
        }

        static {
            AS_DEFAULT_VALUE = new String("true");
        }
    }
}

