/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.DefaultUdcInformationCollector;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.udc.UsageData;

public class UdcKernelExtension
extends LifecycleAdapter {
    private Timer timer;
    private IdGeneratorFactory idGeneratorFactory;
    private final UsageData usageData;
    private final Config config;
    private final DataSourceManager dataSourceManager;

    UdcKernelExtension(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory, UsageData usageData, Timer timer) {
        this.config = config;
        this.dataSourceManager = dataSourceManager;
        this.idGeneratorFactory = idGeneratorFactory;
        this.usageData = usageData;
        this.timer = timer;
    }

    public void start() {
        if (!((Boolean)this.config.get(UdcSettings.udc_enabled)).booleanValue()) {
            return;
        }
        int firstDelay = (Integer)this.config.get(UdcSettings.first_delay);
        int interval = (Integer)this.config.get(UdcSettings.interval);
        HostnamePort hostAddress = (HostnamePort)this.config.get(UdcSettings.udc_host);
        DefaultUdcInformationCollector collector = new DefaultUdcInformationCollector(this.config, this.dataSourceManager, this.idGeneratorFactory, this.usageData);
        UdcTimerTask task = new UdcTimerTask(hostAddress, collector);
        this.timer.scheduleAtFixedRate((TimerTask)task, firstDelay, (long)interval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

