/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.util.Timer;
import org.neo4j.ext.udc.impl.UdcKernelExtension;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.StartupStatistics;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.udc.UsageData;

public class UdcKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    static final String KEY = "kernel udc";

    public UdcKernelExtensionFactory() {
        super(KEY);
    }

    public Lifecycle newInstance(KernelContext kernelContext, Dependencies dependencies) throws Throwable {
        Config config = dependencies.config();
        return new UdcKernelExtension(config, dependencies.dataSourceManager(), dependencies.idGeneratorFactory(), dependencies.startupStats(), dependencies.usageData(), new Timer("Neo4j UDC Timer", this.isAlwaysDaemon()));
    }

    private boolean isAlwaysDaemon() {
        return true;
    }

    public static interface Dependencies {
        public Config config();

        public DataSourceManager dataSourceManager();

        public UsageData usageData();

        public IdGeneratorFactory idGeneratorFactory();

        public StartupStatistics startupStats();
    }
}

