/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.udc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLog;
import org.neo4j.udc.UserDataCollectorSource;

public class CustomPluginUDC
implements UserDataCollectorSource {
    private static final Predicate<String> JAR_FILE_PATTERN = Pattern.compile(".*\\.jar$", 2).asPredicate();
    private static final Predicate<String> GDS_JAR_PATTERN = Pattern.compile("^neo4j-graph-data-science-.*\\.jar$", 2).asPredicate();
    private static final Predicate<String> APOC_CORE_JAR_PATTERN = Pattern.compile("^apoc-.*-core\\.jar$", 2).asPredicate();
    private static final Predicate<String> APOC_EXTENDED_JAR_PATTERN = Pattern.compile("^apoc-.*-(all|extended)\\.jar$", 2).asPredicate();
    private static final Predicate<String> GEN_AI_PATTERN = Pattern.compile("^neo4j-genai-.*\\.jar$", 2).asPredicate();
    private static final Predicate<String> BLOOM_PATTERN = Pattern.compile("^bloom-plugin-.*\\.jar$", 2).asPredicate();
    public static final String APOC_EXTENDED_PRESENT_KEY = "apocExtendedPresent";
    public static final String EXTERNAL_PLUGIN_PRESENT_KEY = "externalPluginPresent";

    @Override
    public Map<String, String> getData(DatabaseManagementService databaseManagementService, FileSystemAbstraction fs, Config config, InternalLog log) {
        boolean apocExtendedPresent = false;
        boolean externalPluginPresent = false;
        Path pluginsFolder = (Path)config.get(GraphDatabaseSettings.plugin_dir);
        try {
            Path[] jars;
            for (Path jar : jars = fs.listFiles(pluginsFolder, name -> JAR_FILE_PATTERN.test(name.getFileName().toString()))) {
                String jarName = jar.getFileName().toString();
                if (APOC_EXTENDED_JAR_PATTERN.test(jarName)) {
                    apocExtendedPresent = true;
                    continue;
                }
                if ((APOC_CORE_JAR_PATTERN.test(jarName) || GDS_JAR_PATTERN.test(jarName) || GEN_AI_PATTERN.test(jarName)) && !BLOOM_PATTERN.test(jarName)) continue;
                externalPluginPresent = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Map.of(APOC_EXTENDED_PRESENT_KEY, Boolean.toString(apocExtendedPresent), EXTERNAL_PLUGIN_PRESENT_KEY, Boolean.toString(externalPluginPresent));
    }
}

