/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.UdcInformationCollector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.StartupStatistics;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class DefaultUdcInformationCollector
implements UdcInformationCollector {
    private final Config config;
    private final UsageData usageData;
    private final IdGeneratorFactory idGeneratorFactory;
    private String storeId;
    private boolean crashPing;
    private final Map<String, String> jarNamesForTags = MapUtil.stringMap((String[])new String[]{"spring-", "spring", "(javax.ejb|ejb-jar)", "ejb", "(weblogic|glassfish|websphere|jboss)", "appserver", "openshift", "openshift", "cloudfoundry", "cloudfoundry", "(junit|testng)", "test", "jruby", "ruby", "clojure", "clojure", "jython", "python", "groovy", "groovy", "(tomcat|jetty)", "web", "spring-data-neo4j", "sdn"});

    public DefaultUdcInformationCollector(Config config, DataSourceManager xadsm, IdGeneratorFactory idGeneratorFactory, StartupStatistics startupStats, UsageData usageData) {
        this.config = config;
        this.usageData = usageData;
        this.idGeneratorFactory = idGeneratorFactory;
        final StartupStatistics startupStatistics = startupStats;
        if (xadsm != null) {
            xadsm.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    DefaultUdcInformationCollector.this.crashPing = startupStatistics.numberOfRecoveredTransactions() > 0;
                    DefaultUdcInformationCollector.this.storeId = Long.toHexString(ds.getRandomIdentifier());
                }

                public void unregistered(NeoStoreDataSource ds) {
                    DefaultUdcInformationCollector.this.crashPing = false;
                    DefaultUdcInformationCollector.this.storeId = null;
                }
            });
        }
    }

    public static String filterVersionForUDC(String version) {
        if (!version.contains("+")) {
            return version;
        }
        return version.substring(0, version.indexOf("+"));
    }

    @Override
    public Map<String, String> getUdcParams() {
        String classPath = this.getClassPath();
        HashMap<String, String> udcFields = new HashMap<String, String>();
        this.add(udcFields, "id", this.storeId);
        this.add(udcFields, "v", DefaultUdcInformationCollector.filterVersionForUDC((String)this.usageData.get(UsageDataKeys.version)));
        this.add(udcFields, "revision", DefaultUdcInformationCollector.filterVersionForUDC((String)this.usageData.get(UsageDataKeys.revision)));
        this.add(udcFields, "edition", ((UsageDataKeys.Edition)this.usageData.get(UsageDataKeys.edition)).name().toLowerCase());
        this.add(udcFields, "source", this.config.get(UdcSettings.udc_source));
        this.add(udcFields, "reg", this.config.get(UdcSettings.udc_registration_key));
        this.add(udcFields, "databasemode", ((UsageDataKeys.OperationalMode)this.usageData.get(UsageDataKeys.operationalMode)).name());
        this.add(udcFields, "serverid", this.usageData.get(UsageDataKeys.serverId));
        this.add(udcFields, "ua", this.toCommaString(this.usageData.get(UsageDataKeys.clientNames)));
        this.add(udcFields, "tags", this.determineTags(this.jarNamesForTags, classPath));
        this.add(udcFields, "cluster", this.determineClusterNameHash());
        this.add(udcFields, "mac", this.determineMacAddress());
        this.add(udcFields, "dist", this.determineOsDistribution());
        this.add(udcFields, "numprocs", this.determineNumberOfProcessors());
        this.add(udcFields, "totalmem", this.determineTotalMemory());
        this.add(udcFields, "heapsize", this.determineHeapSize());
        this.add(udcFields, "nodeids", this.determineNodesIdsInUse());
        this.add(udcFields, "relids", this.determineRelationshipIdsInUse());
        this.add(udcFields, "labelids", this.determineLabelIdsInUse());
        this.add(udcFields, "propids", this.determinePropertyIdsInUse());
        udcFields.putAll(this.determineSystemProperties());
        return udcFields;
    }

    private String determineOsDistribution() {
        if (System.getProperties().getProperty("os.name", "").equals("Linux")) {
            return DefaultUdcInformationCollector.searchForPackageSystems();
        }
        return "unknown";
    }

    static String searchForPackageSystems() {
        try {
            if (new File("/bin/rpm").exists()) {
                return "rpm";
            }
            if (new File("/usr/bin/dpkg").exists()) {
                return "dpkg";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private Integer determineClusterNameHash() {
        try {
            Class<?> settings = Class.forName("org.neo4j.cluster.ClusterSettings");
            Setting setting = (Setting)settings.getField("cluster_name").get(null);
            Object name = this.config.get(setting);
            return name != null ? Integer.valueOf(Math.abs(name.hashCode() % Integer.MAX_VALUE)) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String determineTags(Map<String, String> jarNamesForTags, String classPath) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : jarNamesForTags.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            if (!pattern.matcher(classPath).find()) continue;
            result.append(",").append(entry.getValue());
        }
        if (result.length() == 0) {
            return null;
        }
        return result.substring(1);
    }

    private String getClassPath() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        return runtime.getClassPath();
    }

    private String determineMacAddress() {
        String formattedMac = "0";
        try {
            byte[] mac;
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder(mac.length * 2);
                Formatter formatter = new Formatter(sb);
                for (byte b : mac) {
                    formatter.format("%02x", b);
                }
                formattedMac = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return formattedMac;
    }

    private int determineNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    private long determineTotalMemory() {
        return OsBeanUtil.getTotalPhysicalMemory();
    }

    private long determineHeapSize() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private long determineNodesIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.NODE);
    }

    private long determineLabelIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.LABEL_TOKEN);
    }

    private long determinePropertyIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.PROPERTY);
    }

    private long determineRelationshipIdsInUse() {
        return this.getNumberOfIdsInUse(IdType.RELATIONSHIP);
    }

    private long getNumberOfIdsInUse(IdType type) {
        return this.idGeneratorFactory.get(type).getNumberOfIdsInUse();
    }

    private String toCommaString(Object values) {
        StringBuilder result = new StringBuilder();
        if (values instanceof Iterable) {
            for (Object agent : (Iterable)values) {
                if (agent == null) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(agent);
            }
        } else {
            result.append(values);
        }
        return result.toString();
    }

    private void add(Map<String, String> udcFields, String name, Object value) {
        if (value == null) {
            return;
        }
        String str = value.toString().trim();
        if (str.isEmpty()) {
            return;
        }
        udcFields.put(name, str);
    }

    private String removeUdcPrefix(String propertyName) {
        if (propertyName.startsWith("neo4j.ext.udc")) {
            return propertyName.substring("neo4j.ext.udc".length() + 1);
        }
        return propertyName;
    }

    private String sanitizeUdcProperty(String propertyValue) {
        return propertyValue.replace(' ', '_');
    }

    private Map<String, String> determineSystemProperties() {
        HashMap<String, String> relevantSysProps = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        Enumeration<?> sysPropsNames = sysProps.propertyNames();
        while (sysPropsNames.hasMoreElements()) {
            String sysPropName = (String)sysPropsNames.nextElement();
            if (!sysPropName.startsWith("neo4j.ext.udc") && !sysPropName.startsWith("os")) continue;
            String propertyValue = sysProps.getProperty(sysPropName);
            relevantSysProps.put(this.removeUdcPrefix(sysPropName), this.sanitizeUdcProperty(propertyValue));
        }
        return relevantSysProps;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public boolean getCrashPing() {
        return this.crashPing;
    }
}

