/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.neo4j.ext.udc.Edition;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.UdcInformationCollector;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;

public class DefaultUdcInformationCollector
implements UdcInformationCollector {
    private final Config config;
    private final KernelData kernel;
    private final String storeId;
    private final boolean crashPing;
    private final Map<String, String> jarNamesForTags = MapUtil.stringMap((String[])new String[]{"spring-", "spring", "(javax.ejb|ejb-jar)", "ejb", "(weblogic|glassfish|websphere|jboss)", "appserver", "openshift", "openshift", "cloudfoundry", "cloudfoundry", "(junit|testng)", "test", "jruby", "ruby", "clojure", "clojure", "jython", "python", "groovy", "groovy", "(tomcat|jetty)", "web", "spring-data-neo4j", "sdn"});

    public DefaultUdcInformationCollector(Config config, KernelData kernel) {
        this.config = config;
        this.kernel = kernel;
        NeoStoreXaDataSource ds = kernel.graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
        this.crashPing = ds.getXaContainer().getLogicalLog().wasNonClean();
        this.storeId = Long.toHexString(ds.getRandomIdentifier());
    }

    @Override
    public Map<String, String> getUdcParams() {
        String classPath = this.getClassPath();
        HashMap<String, String> udcFields = new HashMap<String, String>();
        this.add(udcFields, "id", this.storeId);
        this.add(udcFields, "v", this.kernel.version().getReleaseVersion());
        this.add(udcFields, "revision", this.kernel.version().getRevision());
        this.add(udcFields, "edition", (Object)this.determineEdition(classPath));
        this.add(udcFields, "tags", this.determineTags(this.jarNamesForTags, classPath));
        this.add(udcFields, "cluster", this.determineClusterNameHash());
        this.add(udcFields, "source", this.config.get(UdcSettings.udc_source));
        this.add(udcFields, "reg", this.config.get(UdcSettings.udc_registration_key));
        this.add(udcFields, "mac", this.determineMacAddress());
        this.add(udcFields, "dist", this.determineOsDistribution());
        this.add(udcFields, "ua", this.determineUserAgents());
        udcFields.putAll(this.determineSystemProperties());
        return udcFields;
    }

    private String determineOsDistribution() {
        if (System.getProperties().getProperty("os.name", "").equals("Linux")) {
            return DefaultUdcInformationCollector.searchForPackageSystems();
        }
        return "unknown";
    }

    static String searchForPackageSystems() {
        try {
            if (new File("/bin/rpm").exists()) {
                return "rpm";
            }
            if (new File("/usr/bin/dpkg").exists()) {
                return "dpkg";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private Integer determineClusterNameHash() {
        try {
            Class<?> haSettings = Class.forName("org.neo4j.kernel.ha.HaSettings");
            GraphDatabaseSetting.StringSetting setting = (GraphDatabaseSetting.StringSetting)haSettings.getField("cluster_name").get(null);
            String name = (String)this.config.get((GraphDatabaseSetting)setting);
            return name != null ? Integer.valueOf(Math.abs(name.hashCode())) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Edition determineEdition(String classPath) {
        if (classPath.contains("neo4j-ha")) {
            return Edition.enterprise;
        }
        if (classPath.contains("neo4j-management")) {
            return Edition.advanced;
        }
        return Edition.community;
    }

    private String determineTags(Map<String, String> jarNamesForTags, String classPath) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : jarNamesForTags.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            if (!pattern.matcher(classPath).find()) continue;
            result.append(",").append(entry.getValue());
        }
        if (result.length() == 0) {
            return null;
        }
        return result.substring(1);
    }

    private String getClassPath() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        return runtime.getClassPath();
    }

    private String determineMacAddress() {
        String formattedMac = "0";
        try {
            byte[] mac;
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder(mac.length * 2);
                Formatter formatter = new Formatter(sb);
                for (byte b : mac) {
                    formatter.format("%02x", b);
                }
                formattedMac = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return formattedMac;
    }

    private String determineUserAgents() {
        try {
            Class<?> filter = Class.forName("org.neo4j.server.rest.web.CollectUserAgentFilter");
            Object agents = filter.getMethod("getUserAgents", new Class[0]).invoke(null, new Object[0]);
            String result = this.toCommaString(agents);
            filter.getMethod("reset", new Class[0]).invoke(null, new Object[0]);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String toCommaString(Object values) {
        StringBuilder result = new StringBuilder();
        if (values instanceof Iterable) {
            for (Object agent : (Iterable)values) {
                if (agent == null) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(agent);
            }
        } else {
            result.append(values);
        }
        return result.toString();
    }

    private void add(Map<String, String> udcFields, String name, Object value) {
        if (value == null) {
            return;
        }
        String str = value.toString().trim();
        if (str.isEmpty()) {
            return;
        }
        udcFields.put(name, str);
    }

    private String removeUdcPrefix(String propertyName) {
        if (propertyName.startsWith("neo4j.ext.udc")) {
            return propertyName.substring("neo4j.ext.udc".length() + 1);
        }
        return propertyName;
    }

    private String sanitizeUdcProperty(String propertyValue) {
        return propertyValue.replace(' ', '_');
    }

    private Map<String, String> determineSystemProperties() {
        HashMap<String, String> relevantSysProps = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        Enumeration<?> sysPropsNames = sysProps.propertyNames();
        while (sysPropsNames.hasMoreElements()) {
            String sysPropName = (String)sysPropsNames.nextElement();
            if (!sysPropName.startsWith("neo4j.ext.udc") && !sysPropName.startsWith("os")) continue;
            String propertyValue = sysProps.getProperty(sysPropName);
            relevantSysProps.put(this.removeUdcPrefix(sysPropName), this.sanitizeUdcProperty(propertyValue));
        }
        return relevantSysProps;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public boolean getCrashPing() {
        return this.crashPing;
    }
}

