/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.neo4j.ext.udc.impl.Pinger;

public class UdcTimerTask
extends TimerTask {
    public static final Map<String, Integer> successCounts = new HashMap<String, Integer>();
    public static final Map<String, Integer> failureCounts = new HashMap<String, Integer>();
    private final String storeId;
    private final Pinger pinger;

    public UdcTimerTask(String host, String storeId, boolean crashPing, Map<String, String> params) {
        successCounts.put(storeId, 0);
        failureCounts.put(storeId, 0);
        this.storeId = storeId;
        this.pinger = new Pinger(host, params, crashPing);
    }

    @Override
    public void run() {
        try {
            this.pinger.ping();
            this.incrementSuccessCount(this.storeId);
        }
        catch (IOException e) {
            this.incrementFailureCount(this.storeId);
        }
    }

    private void incrementSuccessCount(String storeId) {
        Integer currentCount;
        Integer n = currentCount = successCounts.get(storeId);
        Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
        successCounts.put(storeId, currentCount);
    }

    private void incrementFailureCount(String storeId) {
        Integer currentCount;
        Integer n = currentCount = failureCounts.get(storeId);
        Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
        failureCounts.put(storeId, currentCount);
    }
}

