/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;

public class UdcExtensionImpl
extends KernelExtension<UdcTimerTask> {
    static final String KEY = "kernel udc";
    private Timer timer;
    private final Map<String, String> jarNamesForTags = MapUtil.stringMap((String[])new String[]{"spring-", "spring", "(javax.ejb|ejb-jar)", "ejb", "(weblogic|glassfish|websphere|jboss)", "appserver", "openshift", "openshift", "cloudfoundry", "cloudfoundry", "(junit|testng)", "test", "jruby", "ruby", "clojure", "clojure", "jython", "python", "groovy", "groovy", "(tomcat|jetty)", "web"});

    public UdcExtensionImpl() {
        super(KEY);
    }

    public Class getSettingsClass() {
        return UdcSettings.class;
    }

    protected UdcTimerTask load(KernelData kernel) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        Map<String, String> conf = this.loadSystemProperties();
        conf.putAll(kernel.getConfigParams());
        Config config = new Config(conf);
        if (!config.getBoolean(UdcSettings.udc_enabled)) {
            return null;
        }
        int firstDelay = config.getInteger(UdcSettings.first_delay);
        int interval = config.getInteger(UdcSettings.interval);
        String hostAddress = config.get((GraphDatabaseSetting)UdcSettings.udc_host);
        String source = config.get((GraphDatabaseSetting)UdcSettings.udc_source);
        String registration = config.get((GraphDatabaseSetting)UdcSettings.udc_registration_key);
        NeoStoreXaDataSource ds = kernel.graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
        boolean crashPing = ds.getXaContainer().getLogicalLog().wasNonClean();
        String storeId = Long.toHexString(ds.getRandomIdentifier());
        String version = kernel.version().getRevision();
        if (version.equals("")) {
            version = kernel.version().getVersion();
        }
        UdcTimerTask task = new UdcTimerTask(hostAddress, version, storeId, source, crashPing, registration, this.formattedMacAddy(), this.determineTags());
        this.timer = new Timer("Neo4j UDC Timer", true);
        this.timer.scheduleAtFixedRate((TimerTask)task, firstDelay, (long)interval);
        return task;
    }

    private String determineTags() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String classPath = runtime.getClassPath();
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.jarNamesForTags.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            if (!pattern.matcher(classPath).find()) continue;
            result.append(",").append(entry.getValue());
        }
        if (result.length() == 0) {
            return null;
        }
        return result.substring(1);
    }

    protected void unload(UdcTimerTask task) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private Map<String, String> loadSystemProperties() {
        Properties sysProps = new Properties();
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        try {
            InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream("/org/neo4j/ext/udc/udc.properties");
            if (resource != null) {
                sysProps.load(resource);
                for (Map.Entry<Object, Object> objectObjectEntry : sysProps.entrySet()) {
                    stringStringHashMap.put(objectObjectEntry.getKey().toString(), objectObjectEntry.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            System.err.println("failed to load udc.properties, because: " + e);
        }
        return stringStringHashMap;
    }

    private String formattedMacAddy() {
        String formattedMac = "0";
        try {
            byte[] mac;
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder(mac.length * 2);
                Formatter formatter = new Formatter(sb);
                for (byte b : mac) {
                    formatter.format("%02x", b);
                }
                formattedMac = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return formattedMac;
    }
}

