/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.ext.udc.UdcProperties;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;

public class UdcExtensionImpl
extends KernelExtension
implements UdcProperties {
    public static final String UDC_SOURCE_DISTRIBUTION_KEY = "neo4j.ext.udc.host";
    private int firstDelay = 600000;
    private int interval = 86400000;
    private String hostAddress = "udc.neo4j.org";
    private boolean disabled = false;
    private Timer timer;

    public UdcExtensionImpl() {
        super("kernel udc");
    }

    protected void load(KernelExtension.KernelData kernel) {
        this.configure(kernel.getConfig());
        kernel.setState((KernelExtension)this, new Object());
        if (!this.disabled) {
            this.timer = new Timer();
            NeoStoreXaDataSource ds = (NeoStoreXaDataSource)kernel.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
            boolean crashPing = ds.getXaContainer().getLogicalLog().wasNonClean();
            String storeId = Long.toHexString(ds.getRandomIdentifier());
            UdcTimerTask task = new UdcTimerTask(this.hostAddress, Version.VERSION.getRevision(), storeId, crashPing);
            this.timer.scheduleAtFixedRate((TimerTask)task, this.firstDelay, (long)this.interval);
        }
    }

    protected void unload(KernelExtension.KernelData kernel) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void configure(Config config) {
        Properties props = this.loadSystemProperties();
        try {
            String firstDelayAsString = (String)config.getParams().get("neo4j.ext.udc.first_delay");
            if (firstDelayAsString == null) {
                firstDelayAsString = props.getProperty("neo4j.ext.udc.first_delay", "600000");
            }
            this.firstDelay = Integer.parseInt(firstDelayAsString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String intervalAsString = (String)config.getParams().get("neo4j.ext.udc.interval");
            if (intervalAsString == null) {
                intervalAsString = props.getProperty("neo4j.ext.udc.interval", "86400000");
            }
            this.interval = Integer.parseInt(intervalAsString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String possibleHost = (String)config.getParams().get(UDC_SOURCE_DISTRIBUTION_KEY);
            if (null != possibleHost) {
                this.hostAddress = possibleHost;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String disabledAsString = (String)config.getParams().get("neo4j.ext.udc.disable");
        if (disabledAsString == null) {
            disabledAsString = props.getProperty("neo4j.ext.udc.disable", "false");
        }
        this.disabled = Boolean.valueOf(disabledAsString);
    }

    private Properties loadSystemProperties() {
        Properties sysProps = System.getProperties();
        try {
            sysProps.load(this.getClass().getResourceAsStream("/org/neo4j/ext/udc/udc.properties"));
        }
        catch (Exception e) {
            System.err.println("failed to load udc.properties, because: " + e);
        }
        return sysProps;
    }
}

