/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pinger {
    private final String address;
    private final Map<String, String> usageDataMap;
    private int pingCount = 0;

    public Pinger(String address, Map<String, String> usageDataMap, boolean crashPing) {
        this.address = address;
        this.usageDataMap = usageDataMap;
        if (crashPing) {
            this.pingCount = -1;
        }
    }

    public void ping() throws IOException {
        ++this.pingCount;
        StringBuffer uri = new StringBuffer("http://" + this.address + "/" + "?");
        for (String key : this.usageDataMap.keySet()) {
            uri.append(key);
            uri.append("=");
            uri.append(this.usageDataMap.get(key));
            uri.append("+");
        }
        if (this.pingCount == 0) {
            uri.append("p=-1");
            ++this.pingCount;
        } else {
            uri.append("p=").append(this.pingCount);
        }
        URL url = new URL(uri.toString());
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(false);
        con.setUseCaches(false);
        con.connect();
        con.getInputStream();
    }

    public Integer getPingCount() {
        return this.pingCount;
    }
}

