/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.util.ArrayList;
import java.util.function.IntPredicate;
import org.neo4j.exceptions.KernelException;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenRegistry;
import org.neo4j.token.api.NamedToken;

public class RegisteringTokenCreator
implements TokenCreator {
    private final TokenRegistry registry;
    private final TokenCreator creator;

    public RegisteringTokenCreator(TokenRegistry registry, TokenCreator creator) {
        this.registry = registry;
        this.creator = creator;
    }

    @Override
    public int createToken(String name, boolean internal) throws KernelException {
        int id = this.creator.createToken(name, internal);
        this.registry.put(new NamedToken(name, id, internal));
        return id;
    }

    @Override
    public void createTokens(String[] names, int[] ids, boolean internal, IntPredicate indexFilter) throws KernelException {
        this.creator.createTokens(names, ids, internal, indexFilter);
        ArrayList<NamedToken> createdTokensList = new ArrayList<NamedToken>();
        for (int i = 0; i < names.length; ++i) {
            if (!indexFilter.test(i)) continue;
            createdTokensList.add(new NamedToken(names[i], ids[i], internal));
        }
        this.registry.putAll(createdTokensList);
    }
}

