/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.token.api.TokensLoader;

public class TokenHolders
implements TokenNameLookup {
    private final TokenHolder propertyKeyTokens;
    private final TokenHolder labelTokens;
    private final TokenHolder relationshipTypeTokens;

    public TokenHolders(TokenHolder propertyKeyTokens, TokenHolder labelTokens, TokenHolder relationshipTypeTokens) {
        this.propertyKeyTokens = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
    }

    public TokenHolder propertyKeyTokens() {
        return this.propertyKeyTokens;
    }

    public TokenHolder labelTokens() {
        return this.labelTokens;
    }

    public TokenHolder relationshipTypeTokens() {
        return this.relationshipTypeTokens;
    }

    public void setInitialTokens(TokensLoader loader, StoreCursors storeCursors) {
        this.propertyKeyTokens().setInitialTokens(loader.getPropertyKeyTokens(storeCursors));
        this.labelTokens().setInitialTokens(loader.getLabelTokens(storeCursors));
        this.relationshipTypeTokens().setInitialTokens(loader.getRelationshipTypeTokens(storeCursors));
    }

    public String labelGetName(int labelId) {
        try {
            return this.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such label: " + labelId + "]";
        }
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        try {
            return this.relationshipTypeTokens().getTokenById(relationshipTypeId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such relationship type: " + relationshipTypeId + "]";
        }
    }

    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.propertyKeyTokens().getTokenById(propertyKeyId).name();
        }
        catch (TokenNotFoundException e) {
            return "[no such property key: " + propertyKeyId + "]";
        }
    }

    public TokenNameLookup lookupWithIds() {
        return new TokenNameLookup(){

            public String labelGetName(int labelId) {
                return TokenHolders.this.labelGetName(labelId) + "[" + labelId + "]";
            }

            public String relationshipTypeGetName(int relationshipTypeId) {
                return TokenHolders.this.relationshipTypeGetName(relationshipTypeId) + "[" + relationshipTypeId + "]";
            }

            public String propertyKeyGetName(int propertyKeyId) {
                return TokenHolders.this.propertyKeyGetName(propertyKeyId) + "[" + propertyKeyId + "]";
            }
        };
    }

    public static TokenHolders readOnlyTokenHolders(TokensLoader loader, StoreCursors storeCursors) {
        TokenHolders tokenHolders = new TokenHolders(new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey"), new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label"), new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType"));
        tokenHolders.setInitialTokens(loader, storeCursors);
        return tokenHolders;
    }
}

