/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.token.api.TokensLoader;

public class TokenHolders
implements TokenNameLookup {
    private final TokenHolder propertyKeyTokens;
    private final TokenHolder labelTokens;
    private final TokenHolder relationshipTypeTokens;

    public TokenHolders(TokenHolder propertyKeyTokens, TokenHolder labelTokens, TokenHolder relationshipTypeTokens) {
        this.propertyKeyTokens = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
    }

    public TokenHolder propertyKeyTokens() {
        return this.propertyKeyTokens;
    }

    public TokenHolder labelTokens() {
        return this.labelTokens;
    }

    public TokenHolder relationshipTypeTokens() {
        return this.relationshipTypeTokens;
    }

    public void setInitialTokens(TokensLoader loader) {
        this.propertyKeyTokens().setInitialTokens(loader.getPropertyKeyTokens());
        this.labelTokens().setInitialTokens(loader.getLabelTokens());
        this.relationshipTypeTokens().setInitialTokens(loader.getRelationshipTypeTokens());
    }

    public String labelGetName(int labelId) {
        return this.getNameById(this.labelTokens, labelId);
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        return this.getNameById(this.relationshipTypeTokens, relationshipTypeId);
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return this.getNameById(this.propertyKeyTokens, propertyKeyId);
    }

    private String getNameById(TokenHolder tokenHolder, int tokenId) {
        try {
            return tokenHolder.getTokenById(tokenId).name();
        }
        catch (TokenNotFoundException e) {
            return String.format("<unknown name>[%d]", tokenId);
        }
    }
}

