/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsChanges;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.internal.counts.MapCountsChanges;
import org.neo4j.internal.counts.TreeWriter;
import org.neo4j.logging.InternalLogProvider;

class DeltaTreeWriter
implements CountUpdater.CountWriter {
    private final ThrowingSupplier<Writer<CountsKey, CountsValue>, IOException> treeWriter;
    private final Function<CountsKey, AtomicLong> defaultToStoredCount;
    private final Comparator<CountsKey> comparator;
    private final int maxCacheSize;
    private final InternalLogProvider userLogProvider;
    private CountsChanges changes = new MapCountsChanges();
    private int changeCounter;

    DeltaTreeWriter(ThrowingSupplier<Writer<CountsKey, CountsValue>, IOException> treeWriter, ToLongFunction<CountsKey> lookup, Comparator<CountsKey> comparator, int maxCacheSize, InternalLogProvider userLogProvider) {
        this.treeWriter = treeWriter;
        this.defaultToStoredCount = k -> new AtomicLong(lookup.applyAsLong((CountsKey)k));
        this.comparator = comparator;
        this.maxCacheSize = maxCacheSize;
        this.userLogProvider = userLogProvider;
    }

    @Override
    public boolean write(CountsKey key, long delta) {
        boolean result = this.changes.add(key, delta, this.defaultToStoredCount);
        if (++this.changeCounter == 100) {
            this.changeCounter = 0;
            if (this.changes.size() > this.maxCacheSize) {
                this.writeChanges();
            }
        }
        return result;
    }

    private void writeChanges() {
        try (TreeWriter writer = new TreeWriter((Writer<CountsKey, CountsValue>)((Writer)this.treeWriter.get()), this.userLogProvider);){
            this.changes.sortedChanges(this.comparator).forEach(entry -> writer.write((CountsKey)entry.getKey(), ((AtomicLong)entry.getValue()).get()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.changes = new MapCountsChanges();
    }

    @Override
    public void close() {
        this.writeChanges();
    }
}

