/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.consistency.checking.index.IndexDescriptorProvider;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;

public class IndexAccessors
implements Closeable {
    private static final String CONSISTENCY_INDEX_ACCESSOR_BUILDER_TAG = "consistencyIndexAccessorBuilder";
    private final MutableLongObjectMap<IndexAccessor> propertyIndexAccessors = new LongObjectHashMap();
    private final List<IndexDescriptor> onlineIndexRules = new ArrayList<IndexDescriptor>();
    private final List<IndexDescriptor> notOnlineIndexRules = new ArrayList<IndexDescriptor>();
    private final List<IndexDescriptor> inconsistentRules = new ArrayList<IndexDescriptor>();
    private IndexAccessor nodeLabelIndex;
    private IndexAccessor relationshipTypeIndex;

    public IndexAccessors(IndexProviderMap providers, IndexDescriptorProvider indexes, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour behavior) {
        this(providers, indexes, samplingConfig, null, tokenNameLookup, contextFactory, openOptions, behavior);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexAccessors(IndexProviderMap providers, IndexDescriptorProvider descriptorProvider, IndexSamplingConfig samplingConfig, IndexAccessorLookup accessorLookup, TokenNameLookup tokenNameLookup, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour behavior) {
        try (CursorContext cursorContext = contextFactory.create(CONSISTENCY_INDEX_ACCESSOR_BUILDER_TAG);){
            accessorLookup = accessorLookup != null ? accessorLookup : index -> IndexAccessors.provider(providers, index).getOnlineAccessor(index, samplingConfig, tokenNameLookup, openOptions, true);
            try (ResourceIterator<IndexDescriptor> descriptors = descriptorProvider.indexDescriptors(cursorContext);){
                while (descriptors.hasNext()) {
                    try {
                        IndexDescriptor indexDescriptor = (IndexDescriptor)descriptors.next();
                        IndexProvider indexProvider = IndexAccessors.provider(providers, indexDescriptor);
                        indexDescriptor = indexProvider.completeConfiguration(indexDescriptor, behavior);
                        if (indexDescriptor.isUnique() && indexDescriptor.getOwningConstraintId().isEmpty()) {
                            this.notOnlineIndexRules.add(indexDescriptor);
                            continue;
                        }
                        if (InternalIndexState.ONLINE == indexProvider.getInitialState(indexDescriptor, cursorContext, openOptions)) {
                            long indexId = indexDescriptor.getId();
                            try {
                                IndexAccessor accessor = accessorLookup.apply(indexDescriptor);
                                if (indexDescriptor.isTokenIndex()) {
                                    if (indexDescriptor.schema().entityType() == EntityType.NODE) {
                                        this.nodeLabelIndex = accessor;
                                        continue;
                                    }
                                    this.relationshipTypeIndex = accessor;
                                    continue;
                                }
                                this.propertyIndexAccessors.put(indexId, (Object)accessor);
                                this.onlineIndexRules.add(indexDescriptor);
                            }
                            catch (RuntimeException e) {
                                this.inconsistentRules.add(indexDescriptor);
                            }
                            continue;
                        }
                        this.notOnlineIndexRules.add(indexDescriptor);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }
    }

    private static IndexProvider provider(IndexProviderMap providers, IndexDescriptor indexRule) {
        return providers.lookup(indexRule.getIndexProvider());
    }

    public Collection<IndexDescriptor> notOnlineRules() {
        return this.notOnlineIndexRules;
    }

    public Collection<IndexDescriptor> inconsistentRules() {
        return this.inconsistentRules;
    }

    public IndexAccessor accessorFor(IndexDescriptor indexRule) {
        return this.accessorFor(indexRule.getId());
    }

    public IndexAccessor accessorFor(long indexRuleId) {
        return (IndexAccessor)this.propertyIndexAccessors.get(indexRuleId);
    }

    public List<IndexDescriptor> onlineRules() {
        return this.onlineIndexRules;
    }

    public List<IndexDescriptor> onlineRules(EntityType entityType) {
        return this.onlineIndexRules.stream().filter(index -> index.schema().entityType() == entityType).collect(Collectors.toList());
    }

    public IndexAccessor nodeLabelIndex() {
        return this.nodeLabelIndex;
    }

    public IndexAccessor relationshipTypeIndex() {
        return this.relationshipTypeIndex;
    }

    public IndexReaders readers() {
        return new IndexReaders();
    }

    public void remove(IndexDescriptor descriptor) {
        IndexAccessor remove = (IndexAccessor)this.propertyIndexAccessors.remove(descriptor.getId());
        if (remove != null) {
            remove.close();
        }
        this.onlineIndexRules.remove(descriptor);
        this.notOnlineIndexRules.remove(descriptor);
    }

    @Override
    public void close() {
        try {
            MutableList closeables = this.propertyIndexAccessors.toList();
            closeables.add((Object)this.nodeLabelIndex);
            closeables.add((Object)this.relationshipTypeIndex);
            IOUtils.closeAllUnchecked((Collection)closeables);
        }
        finally {
            this.propertyIndexAccessors.clear();
            this.onlineIndexRules.clear();
            this.notOnlineIndexRules.clear();
        }
    }

    @FunctionalInterface
    public static interface IndexAccessorLookup {
        public IndexAccessor apply(IndexDescriptor var1) throws IOException;
    }

    public class IndexReaders
    implements AutoCloseable {
        private final MutableLongObjectMap<ValueIndexReader> readers = new LongObjectHashMap();

        public ValueIndexReader reader(IndexDescriptor index) {
            long indexId = index.getId();
            ValueIndexReader reader = (ValueIndexReader)this.readers.get(indexId);
            if (reader == null) {
                reader = ((IndexAccessor)IndexAccessors.this.propertyIndexAccessors.get(indexId)).newValueReader(IndexUsageTracker.NO_USAGE_TRACKER);
                this.readers.put(indexId, (Object)reader);
            }
            return reader;
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked((Collection)this.readers.values());
            this.readers.clear();
        }
    }
}

