/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.graphdb.Direction;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipDirection;

public class EagerDegrees
implements Degrees,
Degrees.Mutator {
    private static final int FIRST_TYPE_UNDECIDED = -1;
    private int firstType = -1;
    private Degree firstTypeDegrees;
    private MutableIntObjectMap<Degree> degrees;

    public boolean add(int type, int outgoing, int incoming, int loop) {
        this.getOrCreateDegree(type).add(outgoing, incoming, loop);
        return true;
    }

    public void add(int type, RelationshipDirection direction, int count) {
        switch (direction) {
            case OUTGOING: {
                this.addOutgoing(type, count);
                break;
            }
            case INCOMING: {
                this.addIncoming(type, count);
                break;
            }
            case LOOP: {
                this.addLoop(type, count);
                break;
            }
        }
    }

    public void addOutgoing(int type, int count) {
        this.getOrCreateDegree((int)type).outgoing += count;
    }

    public void addIncoming(int type, int count) {
        this.getOrCreateDegree((int)type).incoming += count;
    }

    public void addLoop(int type, int count) {
        this.getOrCreateDegree((int)type).loop += count;
    }

    public int rawOutgoingDegree(int type) {
        Degree degree = this.findDegree(type);
        return degree != null ? degree.outgoing : 0;
    }

    public int rawIncomingDegree(int type) {
        Degree degree = this.findDegree(type);
        return degree != null ? degree.incoming : 0;
    }

    public int rawLoopDegree(int type) {
        Degree degree = this.findDegree(type);
        return degree != null ? degree.loop : 0;
    }

    private Degree getOrCreateDegree(int type) {
        if (this.firstType == -1) {
            this.firstType = type;
            this.firstTypeDegrees = new Degree();
            return this.firstTypeDegrees;
        }
        if (this.firstType == type) {
            return this.firstTypeDegrees;
        }
        if (this.degrees == null) {
            this.degrees = IntObjectMaps.mutable.empty();
        }
        return (Degree)this.degrees.getIfAbsentPut(type, Degree::new);
    }

    public int[] types() {
        if (this.firstType == -1) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        if (this.degrees == null) {
            return new int[]{this.firstType};
        }
        int[] types = new int[this.degrees.size() + 1];
        types[0] = this.firstType;
        System.arraycopy(this.degrees.keySet().toArray(), 0, types, 1, this.degrees.size());
        return types;
    }

    public int degree(int type, Direction direction) {
        Degree degree = this.findDegree(type);
        if (degree == null) {
            return 0;
        }
        switch (direction) {
            case OUTGOING: {
                return degree.outgoing + degree.loop;
            }
            case INCOMING: {
                return degree.incoming + degree.loop;
            }
            case BOTH: {
                return degree.outgoing + degree.incoming + degree.loop;
            }
        }
        throw new IllegalArgumentException("Unrecognized direction " + direction);
    }

    public Degree findDegree(int type) {
        Degree degree = null;
        if (this.firstType == type) {
            degree = this.firstTypeDegrees;
        } else if (this.degrees != null) {
            degree = (Degree)this.degrees.get(type);
        }
        return degree;
    }

    public void addAll(EagerDegrees degrees) {
        for (int type : degrees.types()) {
            this.add(type, degrees.rawOutgoingDegree(type), degrees.rawIncomingDegree(type), degrees.rawLoopDegree(type));
        }
    }

    public void clear() {
        this.firstType = -1;
        this.firstTypeDegrees = null;
        this.degrees = null;
    }

    public boolean isEmpty() {
        if (this.firstTypeDegrees == null) {
            return true;
        }
        for (int type : this.types()) {
            if (this.findDegree(type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasType(int type) {
        return this.firstType == type || this.degrees != null && this.degrees.containsKey(type);
    }

    public boolean isSplit() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EagerDegrees that = (EagerDegrees)o;
        int[] types = this.types();
        int[] otherTypes = that.types();
        Arrays.sort(types);
        Arrays.sort(otherTypes);
        if (!Arrays.equals(types, otherTypes)) {
            return false;
        }
        for (int type : types) {
            if (this.findDegree(type).equals(that.findDegree(type))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int type : this.types()) {
            result = result * 31 + this.findDegree(type).hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder degrees = new StringBuilder();
        for (int type : this.types()) {
            degrees.append(degrees.length() > 0 ? ", " : "").append(":").append(type).append(this.findDegree(type));
        }
        return String.format("Degrees{%s}", degrees);
    }

    public static class Degree {
        private int outgoing;
        private int incoming;
        private int loop;

        void add(int outgoing, int incoming, int loop) {
            this.outgoing += outgoing;
            this.incoming += incoming;
            this.loop += loop;
        }

        public int outgoing() {
            return this.outgoing;
        }

        public int incoming() {
            return this.incoming;
        }

        public int loop() {
            return this.loop;
        }

        public int total() {
            return this.outgoing + this.incoming + this.loop;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Degree degree = (Degree)o;
            return this.outgoing == degree.outgoing && this.incoming == degree.incoming && this.loop == degree.loop;
        }

        public int hashCode() {
            return Objects.hash(this.outgoing, this.incoming, this.loop);
        }

        public String toString() {
            return "[out:" + this.outgoing + ", in:" + this.incoming + ", loop:" + this.loop + "]";
        }

        public boolean isEmpty() {
            return this.outgoing == 0 && this.incoming == 0 && this.loop == 0;
        }
    }
}

