/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.counts.CountsStore;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsStoreProvider;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLogProvider;

public class DefaultCountsStoreProvider
implements CountsStoreProvider {
    @Override
    public CountsStore openCountsStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions, CountsBuilder initialCountsBuilder, boolean readOnly, VersionStorage versionStorage) {
        try {
            return new GBPTreeCountsStore(pageCache, layout.countStore(), fs, recoveryCleanupWorkCollector, initialCountsBuilder, readOnly, GBPTreeGenericCountsStore.NO_MONITOR, layout.getDatabaseName(), (Integer)config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries), userLogProvider, contextFactory, pageCacheTracer, openOptions);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public int getPriority() {
        return 1000;
    }
}

