/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.io.Serializable;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.diffset.LongDiffSets;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnspecifiedKernelException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.DegreeVisitor;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.util.EagerDegrees;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final CountsDelta counts;
    private final ReadableTransactionState txState;
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipScanCursor relationshipCursor;

    public TransactionCountingStateVisitor(TxStateVisitor next, StorageReader storageReader, ReadableTransactionState txState, CountsDelta counts, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(next);
        this.txState = txState;
        this.counts = counts;
        this.nodeCursor = storageReader.allocateNodeCursor(cursorContext, storeCursors, memoryTracker);
        this.relationshipCursor = storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors, memoryTracker);
    }

    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1, 1L);
        super.visitCreatedNode(id);
    }

    public void visitDeletedNode(long id) {
        this.counts.incrementNodeCount(-1, -1L);
        this.nodeCursor.single(id);
        if (this.nodeCursor.next()) {
            this.decrementCountForLabelsAndRelationships(this.nodeCursor);
        }
        super.visitDeletedNode(id);
    }

    private void decrementCountForLabelsAndRelationships(StorageNodeCursor node) {
        int[] labelIds;
        for (int labelId : labelIds = node.labels()) {
            this.counts.incrementNodeCount(labelId, -1L);
        }
        TransactionCountingStateVisitor.visitDegrees(node, (type, out, in) -> this.updateRelationshipsCountsFromDegrees(labelIds, type, -out, -in));
    }

    private static void visitDegrees(StorageNodeCursor node, DegreeVisitor visitor) {
        EagerDegrees degrees = new EagerDegrees();
        node.degrees(RelationshipSelection.ALL_RELATIONSHIPS, (Degrees.Mutator)degrees);
        for (int type : degrees.types()) {
            visitor.visitDegree(type, (long)degrees.outgoingDegree(type), (long)degrees.incomingDegree(type));
        }
    }

    public void visitRelationshipModifications(RelationshipModifications ids) throws ConstraintValidationException {
        ids.creations().forEach((id, type, startNode, endNode, addedProps, changedProps, removedProps) -> this.updateRelationshipCount(startNode, type, endNode, 1));
        ids.deletions().forEach((id, type, startNode, endNode, addedProps, changedProps, removedProps) -> {
            if (type == -1) {
                this.relationshipCursor.single(id);
                if (!this.relationshipCursor.next()) {
                    throw new IllegalStateException("Relationship being deleted should exist along with its nodes. Relationship[" + id + "]");
                }
                this.updateRelationshipCount(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.type(), this.relationshipCursor.targetNodeReference(), -1);
            } else {
                this.updateRelationshipCount(startNode, type, endNode, -1);
            }
        });
        super.visitRelationshipModifications(ids);
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            added.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount((int)label, 1L));
            removed.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount((int)label, -1L));
            this.nodeCursor.single(id);
            if (this.nodeCursor.next()) {
                TransactionCountingStateVisitor.visitDegrees(this.nodeCursor, (type, out, in) -> {
                    added.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, (int)label, out, in));
                    removed.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, (int)label, -out, -in));
                });
            }
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(int[] labels, int type, long outgoing, long incoming) {
        for (int label : labels) {
            this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming);
        }
    }

    private void updateRelationshipsCountsFromDegrees(int type, int label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCountsForLabelChange(type, label, outgoing, incoming);
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1, (long)delta, 0L);
        this.visitLabels(startNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, (int)labelId, (long)delta, 0L));
        this.visitLabels(endNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, (int)labelId, 0L, (long)delta));
    }

    private void visitLabels(long nodeId, LongConsumer visitor) {
        if (this.txState.nodeIsDeletedInThisBatch(nodeId)) {
            return;
        }
        if (this.txState.nodeIsAddedInThisBatch(nodeId)) {
            this.txState.getNodeState(nodeId).labelDiffSets().getAdded().forEach(visitor::accept);
        } else {
            this.nodeCursor.single(nodeId);
            if (this.nodeCursor.next()) {
                int[] labels = this.nodeCursor.labels();
                LongDiffSets labelDiff = this.txState.getNodeState(nodeId).labelDiffSets();
                labelDiff.getAdded().forEach(visitor::accept);
                for (int label : labels) {
                    if (labelDiff.isRemoved((long)label)) continue;
                    visitor.accept(label);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void close() throws KernelException {
        Throwable exception;
        block11: {
            exception = null;
            super.close();
            try {
                IOUtils.closeAllUnchecked((AutoCloseable[])new StorageEntityScanCursor[]{this.nodeCursor, this.relationshipCursor});
            }
            catch (Error | RuntimeException e) {
                exception = Exceptions.chain((Throwable)exception, (Throwable)e);
            }
            break block11;
            catch (Error | RuntimeException | KernelException e) {
                try {
                    exception = e;
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeAllUnchecked((AutoCloseable[])new StorageEntityScanCursor[]{this.nodeCursor, this.relationshipCursor});
                    }
                    catch (Error | RuntimeException e2) {
                        exception = Exceptions.chain((Throwable)exception, (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    IOUtils.closeAllUnchecked((AutoCloseable[])new StorageEntityScanCursor[]{this.nodeCursor, this.relationshipCursor});
                }
                catch (Error | RuntimeException e3) {
                    exception = Exceptions.chain((Throwable)exception, (Throwable)e3);
                }
            }
        }
        if (exception != null) {
            Exceptions.throwIfInstanceOf((Throwable)exception, KernelException.class);
            Exceptions.throwIfUnchecked((Throwable)exception);
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).withClassification((GqlClassification)ErrorClassification.UNKNOWN).build();
            throw new UnspecifiedKernelException(gql, (Status)Status.General.UnknownError, exception);
        }
    }
}

