/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.util.Preconditions;

public abstract class CountsChanges {
    static final long ABSENT = -1L;
    protected final ConcurrentMap<CountsKey, AtomicLong> changes;
    private volatile ConcurrentMap<CountsKey, AtomicLong> previousChanges;
    private volatile boolean frozen;

    protected CountsChanges(ConcurrentMap<CountsKey, AtomicLong> changes) {
        this.changes = changes;
    }

    CountsChanges freezeAndFork() {
        this.frozen = true;
        CountsChanges fork = this.fork();
        fork.previousChanges = this.changes;
        return fork;
    }

    protected abstract CountsChanges fork();

    void clearPreviousChanges() {
        this.previousChanges = null;
    }

    boolean add(CountsKey key, long delta, Function<CountsKey, AtomicLong> defaultToStoredCount) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0, (String)"Can't make changes in a frozen state");
        long absoluteValueAfterChange = this.getCounter(key, defaultToStoredCount).addAndGet(delta);
        return delta > 0L ? absoluteValueAfterChange - delta == 0L : absoluteValueAfterChange == 0L;
    }

    private AtomicLong getCounter(CountsKey key, Function<CountsKey, AtomicLong> defaultToStoredCount) {
        ConcurrentMap<CountsKey, AtomicLong> prev = this.previousChanges;
        Function<CountsKey, AtomicLong> defaultFunction = prev == null ? defaultToStoredCount : k -> {
            AtomicLong prevCount = (AtomicLong)prev.get(k);
            if (prevCount != null) {
                return new AtomicLong(prevCount.get());
            }
            return (AtomicLong)defaultToStoredCount.apply((CountsKey)k);
        };
        return this.changes.computeIfAbsent(key, defaultFunction);
    }

    Iterable<Map.Entry<CountsKey, AtomicLong>> sortedChanges(Comparator<CountsKey> comparator) {
        ArrayList<Map.Entry<CountsKey, AtomicLong>> sortedChanges = new ArrayList<Map.Entry<CountsKey, AtomicLong>>(this.changes.entrySet());
        sortedChanges.sort((e1, e2) -> comparator.compare((CountsKey)e1.getKey(), (CountsKey)e2.getKey()));
        return sortedChanges;
    }

    boolean containsChange(CountsKey key) {
        if (this.changes.containsKey(key)) {
            return true;
        }
        ConcurrentMap<CountsKey, AtomicLong> prev = this.previousChanges;
        return prev != null && prev.containsKey(key);
    }

    long get(CountsKey key) {
        AtomicLong prevCount;
        AtomicLong count = (AtomicLong)this.changes.get(key);
        if (count != null) {
            return count.get();
        }
        ConcurrentMap<CountsKey, AtomicLong> prev = this.previousChanges;
        if (prev != null && (prevCount = (AtomicLong)prev.get(key)) != null) {
            return prevCount.get();
        }
        return -1L;
    }

    int size() {
        return this.changes.size();
    }
}

