/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;

public final class StoreMigratorFileOperation {
    private StoreMigratorFileOperation() {
    }

    static void fileOperation(FileOperation operation, FileSystemAbstraction fs, DatabaseLayout fromLayout, DatabaseLayout toLayout, Iterable<DatabaseFile> databaseFiles, boolean allowSkipNonExistentFiles, boolean includeIdFile, ExistingTargetStrategy existingTargetStrategy) throws IOException {
        for (DatabaseFile databaseStore : databaseFiles) {
            Path[] pathArray;
            if (includeIdFile) {
                pathArray = (Path[])fromLayout.allFiles(databaseStore).toArray(Path[]::new);
            } else {
                Path[] pathArray2 = new Path[1];
                pathArray = pathArray2;
                pathArray2[0] = fromLayout.file(databaseStore);
            }
            Path[] files = pathArray;
            StoreMigratorFileOperation.perform(operation, fs, fromLayout, toLayout, allowSkipNonExistentFiles, existingTargetStrategy, files);
        }
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, DatabaseLayout fromLayout, DatabaseLayout toLayout, Path[] files, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy) throws IOException {
        StoreMigratorFileOperation.perform(operation, fs, fromLayout, toLayout, allowSkipNonExistentFiles, existingTargetStrategy, files);
    }

    private static void perform(FileOperation operation, FileSystemAbstraction fs, DatabaseLayout fromLayout, DatabaseLayout toLayout, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy, Path[] files) throws IOException {
        for (Path file : files) {
            if (file == null) continue;
            operation.perform(fs, file.getFileName().toString(), fromLayout.databaseDirectory(), allowSkipNonExistentFiles, toLayout.databaseDirectory(), existingTargetStrategy);
        }
    }
}

