/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.IOException;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.storageengine.api.txstate.validation.TransactionConflictException;

public class VersionValidation {
    private static final short PAGE_ID_BITS = 54;

    public static void validatePageVersion(DatabaseFile databaseFile, long pageId, VersionContext versionContext, PageCursor pageCursor, long position, boolean failFast, ResourceLocker validationLockClient, TransactionMonitor transactionMonitor, LockTracer lockTracer) throws IOException {
        long id = pageId | position << 54;
        if (failFast) {
            if (!validationLockClient.tryExclusiveLock(ResourceType.PAGE, id)) {
                throw TransactionConflictException.transactionConflict((DatabaseFile)databaseFile, (long)pageId);
            }
        } else {
            validationLockClient.acquireExclusive(lockTracer, ResourceType.PAGE, new long[]{id});
        }
        if (pageCursor.next(pageId) && versionContext.invisibleHeadObserved()) {
            transactionMonitor.transactionValidationFailure(databaseFile);
            throw TransactionConflictException.transactionConflict((DatabaseFile)databaseFile, (VersionContext)versionContext, (long)pageId);
        }
    }
}

