/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

public class StorageRelationshipByNodeScanCursor
implements StorageEntityScanCursor<AllNodeScan>,
StorageRelationshipCursor {
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipTraversalCursor relationshipCursor;
    private final RelationshipSelection relationshipSelection;
    private boolean newNode;

    public StorageRelationshipByNodeScanCursor(StorageNodeCursor nodeCursor, StorageRelationshipTraversalCursor relationshipCursor, RelationshipSelection relationshipSelection) {
        this.nodeCursor = nodeCursor;
        this.relationshipCursor = relationshipCursor;
        this.relationshipSelection = relationshipSelection;
    }

    public boolean next() {
        if (this.newNode) {
            this.newNode = false;
            if (!this.nodeCursor.next()) {
                return false;
            }
            this.nodeCursor.relationships(this.relationshipCursor, this.relationshipSelection);
        }
        return this.relationshipCursor.next();
    }

    public void reset() {
        this.nodeCursor.reset();
        this.relationshipCursor.reset();
        this.newNode = false;
    }

    public void setForceLoad() {
        this.nodeCursor.setForceLoad();
        this.relationshipCursor.setForceLoad();
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.relationshipCursor});
    }

    public boolean hasProperties() {
        return this.relationshipCursor.hasProperties();
    }

    public Reference propertiesReference() {
        return this.relationshipCursor.propertiesReference();
    }

    public void properties(StoragePropertyCursor propertyCursor, PropertySelection selection) {
        this.relationshipCursor.properties(propertyCursor, selection);
    }

    public long entityReference() {
        return this.relationshipCursor.entityReference();
    }

    public void scan() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean scanBatch(AllNodeScan scan, long sizeHint) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void single(long reference) {
        this.nodeCursor.single(reference);
        this.newNode = true;
    }

    public int type() {
        return this.relationshipCursor.type();
    }

    public long sourceNodeReference() {
        return this.relationshipCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        return this.relationshipCursor.targetNodeReference();
    }
}

