/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pki;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.pki.PemParser;

public final class PkiUtils {
    public static final CertificateFactory CERTIFICATE_FACTORY;

    private PkiUtils() {
    }

    public static X509Certificate[] loadCertificates(FileSystemAbstraction fs, Path certFile) throws CertificateException, IOException {
        Collection<? extends Certificate> c = CERTIFICATE_FACTORY.generateCertificates(PkiUtils.pathToByteStream(fs, certFile));
        return c.toArray(new X509Certificate[0]);
    }

    public static PrivateKey loadPrivateKey(FileSystemAbstraction fs, Path keyFile) throws IOException, KeyException {
        return PkiUtils.loadPrivateKey(fs, keyFile, null);
    }

    public static PrivateKey loadPrivateKey(FileSystemAbstraction fs, Path keyFile, String password) throws IOException, KeyException {
        return new PemParser(PkiUtils.pathToByteStream(fs, keyFile)).getPrivateKey(password);
    }

    public static PrivateKey loadPrivateKey(InputStream inputStream, String password) throws IOException, KeyException {
        return new PemParser(inputStream).getPrivateKey(password);
    }

    public static PublicKey loadPublicKey(FileSystemAbstraction fs, Path publicKey) throws IOException, KeyException {
        return new PemParser(PkiUtils.pathToByteStream(fs, publicKey)).getPublicKey();
    }

    private static InputStream pathToByteStream(FileSystemAbstraction fs, Path path) throws IOException {
        return new ByteArrayInputStream(FileSystemUtils.readAllBytes((FileSystemAbstraction)fs, (Path)path, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

