/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.ClientSideOnConnectSslHandler;

public class SslPolicy {
    private final PrivateKey privateKey;
    private final X509Certificate[] keyCertChain;
    private final List<String> ciphers;
    private final String[] tlsVersions;
    private final ClientAuth clientAuth;
    private final TrustManagerFactory trustManagerFactory;
    private final SslProvider sslProvider;
    private final boolean verifyHostname;
    private final Log log;

    public SslPolicy(PrivateKey privateKey, X509Certificate[] keyCertChain, List<String> tlsVersions, List<String> ciphers, ClientAuth clientAuth, TrustManagerFactory trustManagerFactory, SslProvider sslProvider, boolean verifyHostname, LogProvider logProvider) {
        this.privateKey = privateKey;
        this.keyCertChain = keyCertChain;
        this.tlsVersions = tlsVersions == null ? null : tlsVersions.toArray(new String[0]);
        this.ciphers = ciphers;
        this.clientAuth = clientAuth;
        this.trustManagerFactory = trustManagerFactory;
        this.sslProvider = sslProvider;
        this.verifyHostname = verifyHostname;
        this.log = logProvider.getLog(SslPolicy.class);
    }

    public SslContext nettyServerContext() throws SSLException {
        return SslContextBuilder.forServer((PrivateKey)this.privateKey, (X509Certificate[])this.keyCertChain).sslProvider(this.sslProvider).clientAuth(SslPolicy.forNetty(this.clientAuth)).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory).build();
    }

    public SslContext nettyClientContext() throws SSLException {
        return SslContextBuilder.forClient().sslProvider(this.sslProvider).keyManager(this.privateKey, this.keyCertChain).protocols(this.tlsVersions).ciphers(this.ciphers).trustManager(this.trustManagerFactory).build();
    }

    private static io.netty.handler.ssl.ClientAuth forNetty(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Cannot translate to netty equivalent: " + String.valueOf(clientAuth));
    }

    public ChannelHandler nettyServerHandler(Channel channel) throws SSLException {
        return SslPolicy.nettyServerHandler(channel, this.nettyServerContext());
    }

    private static ChannelHandler nettyServerHandler(Channel channel, SslContext sslContext) {
        SSLEngine sslEngine = sslContext.newEngine(channel.alloc());
        return new SslHandler(sslEngine);
    }

    public ChannelHandler nettyClientHandler(Channel channel) throws SSLException {
        return this.nettyClientHandler(channel, this.nettyClientContext());
    }

    public ChannelHandler nettyClientHandler(Channel channel, SslContext sslContext) {
        return new ClientSideOnConnectSslHandler(channel, sslContext, this.verifyHostname, this.tlsVersions);
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public X509Certificate[] certificateChain() {
        return this.keyCertChain;
    }

    public KeyStore getKeyStore(char[] keyStorePass, char[] privateKeyPass) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.log.debug("Keystore loaded is of type " + keyStore.getClass().getName());
            keyStore.load(null, keyStorePass);
            keyStore.setKeyEntry("key", this.privateKey, privateKeyPass, this.keyCertChain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return keyStore;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public List<String> getCipherSuites() {
        return this.ciphers;
    }

    public String[] getTlsVersions() {
        return this.tlsVersions;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public String toString() {
        return "SslPolicy{keyCertChain=" + this.describeCertChain() + ", ciphers=" + String.valueOf(this.ciphers) + ", tlsVersions=" + Arrays.toString(this.tlsVersions) + ", clientAuth=" + String.valueOf(this.clientAuth) + "}";
    }

    private static String describeCertificate(X509Certificate certificate) {
        return "Subject: " + String.valueOf(certificate.getSubjectDN()) + ", Issuer: " + String.valueOf(certificate.getIssuerDN());
    }

    private String describeCertChain() {
        List certificates = Arrays.stream(this.keyCertChain).map(SslPolicy::describeCertificate).collect(Collectors.toList());
        return String.join((CharSequence)", ", certificates);
    }
}

