/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SearchEnvelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveMonitor;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;

public abstract class SpaceFillingCurve {
    private final Envelope range;
    private final int nbrDim;
    private final int maxLevel;
    private final long width;
    private final long valueWidth;
    private final int quadFactor;
    private final long initialNormMask;
    private double[] scalingFactor;

    SpaceFillingCurve(Envelope range, int maxLevel) {
        this.range = range;
        this.nbrDim = range.getDimension();
        this.maxLevel = maxLevel;
        if (maxLevel < 1) {
            throw new IllegalArgumentException("Hilbert index needs at least one level");
        }
        if (range.getDimension() > 3) {
            throw new IllegalArgumentException("Hilbert index does not yet support more than 3 dimensions");
        }
        this.width = (long)Math.pow(2.0, maxLevel);
        this.scalingFactor = new double[this.nbrDim];
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            this.scalingFactor[dim] = (double)this.width / range.getWidth(dim);
        }
        this.valueWidth = (long)Math.pow(2.0, maxLevel * this.nbrDim);
        this.initialNormMask = (long)(Math.pow(2.0, this.nbrDim) - 1.0) << (maxLevel - 1) * this.nbrDim;
        this.quadFactor = (int)Math.pow(2.0, this.nbrDim);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public long getWidth() {
        return this.width;
    }

    public long getValueWidth() {
        return this.valueWidth;
    }

    public double getTileWidth(int dimension, int level) {
        return this.range.getWidth(dimension) / Math.pow(2.0, level);
    }

    public Envelope getRange() {
        return this.range;
    }

    protected abstract CurveRule rootCurve();

    public Long derivedValueFor(double[] coord) {
        return this.derivedValueFor(coord, this.maxLevel);
    }

    private Long derivedValueFor(double[] coord, int level) {
        this.assertValidLevel(level);
        long[] normalizedValues = this.getNormalizedCoord(coord);
        return this.derivedValueFor(normalizedValues, level);
    }

    public Long derivedValueFor(long[] normalizedValues) {
        return this.derivedValueFor(normalizedValues, this.maxLevel);
    }

    private Long derivedValueFor(long[] normalizedValues, int level) {
        this.assertValidLevel(level);
        long derivedValue = 0L;
        long mask = 1L << this.maxLevel - 1;
        CurveRule currentCurve = this.rootCurve();
        for (int i = 1; i <= this.maxLevel; ++i) {
            int bitIndex = this.maxLevel - i;
            int npoint = 0;
            for (long val : normalizedValues) {
                npoint = npoint << 1 | (int)((val & mask) >> bitIndex);
            }
            int derivedIndex = currentCurve.indexForNPoint(npoint);
            derivedValue = derivedValue << this.nbrDim | (long)derivedIndex;
            mask >>= 1;
            currentCurve = currentCurve.childAt(derivedIndex);
        }
        if (level < this.maxLevel) {
            derivedValue <<= this.nbrDim * this.maxLevel - level;
        }
        return derivedValue;
    }

    public double[] centerPointFor(long derivedValue) {
        return this.centerPointFor(derivedValue, this.maxLevel);
    }

    private double[] centerPointFor(long derivedValue, int level) {
        long[] normalizedCoord = this.normalizedCoordinateFor(derivedValue, level);
        return this.getDoubleCoord(normalizedCoord, level);
    }

    long[] normalizedCoordinateFor(long derivedValue, int level) {
        this.assertValidLevel(level);
        long mask = this.initialNormMask;
        long[] coordinate = new long[this.nbrDim];
        CurveRule currentCurve = this.rootCurve();
        for (int i = 1; i <= level; ++i) {
            int bitIndex = this.maxLevel - i;
            int derivedIndex = (int)((derivedValue & mask) >> bitIndex * this.nbrDim);
            int npoint = currentCurve.npointForIndex(derivedIndex);
            int[] bitValues = this.bitValues(npoint);
            for (int dim = 0; dim < this.nbrDim; ++dim) {
                coordinate[dim] = coordinate[dim] << 1 | (long)bitValues[dim];
            }
            mask >>= this.nbrDim;
            currentCurve = currentCurve.childAt(derivedIndex);
        }
        if (level < this.maxLevel) {
            for (int dim = 0; dim < this.nbrDim; ++dim) {
                coordinate[dim] = coordinate[dim] << this.maxLevel - level;
            }
        }
        return coordinate;
    }

    List<LongRange> getTilesIntersectingEnvelope(Envelope referenceEnvelope) {
        return this.getTilesIntersectingEnvelope(referenceEnvelope.getMin(), referenceEnvelope.getMax(), new StandardConfiguration());
    }

    public List<LongRange> getTilesIntersectingEnvelope(double[] fromOrNull, double[] toOrNull, SpaceFillingCurveConfiguration config) {
        double[] from = fromOrNull == null ? this.range.getMin() : (double[])fromOrNull.clone();
        double[] to = toOrNull == null ? this.range.getMax() : (double[])toOrNull.clone();
        for (int i = 0; i < from.length; ++i) {
            if (!(from[i] > to[i])) continue;
            if (fromOrNull == null) {
                to[i] = from[i];
                continue;
            }
            if (toOrNull == null) {
                from[i] = to[i];
                continue;
            }
            throw new IllegalArgumentException("Invalid range, min greater than max: " + from[i] + " > " + to[i]);
        }
        Envelope referenceEnvelope = new Envelope(from, to);
        return this.getTilesIntersectingEnvelope(referenceEnvelope, config, null);
    }

    List<LongRange> getTilesIntersectingEnvelope(Envelope referenceEnvelope, SpaceFillingCurveConfiguration config, SpaceFillingCurveMonitor monitor) {
        SearchEnvelope search = new SearchEnvelope(this, referenceEnvelope);
        SearchEnvelope wholeExtent = new SearchEnvelope(0L, this.getWidth(), this.nbrDim);
        ArrayList<LongRange> results = new ArrayList<LongRange>(config.initialRangesListCapacity());
        if (monitor != null) {
            monitor.registerSearchArea(search.getArea());
        }
        this.addTilesIntersectingEnvelopeAt(config, monitor, 0, config.maxDepth(referenceEnvelope, this.range, this.nbrDim, this.maxLevel), search, wholeExtent, this.rootCurve(), 0L, this.getValueWidth(), results);
        return results;
    }

    private void addTilesIntersectingEnvelopeAt(SpaceFillingCurveConfiguration config, SpaceFillingCurveMonitor monitor, int depth, int maxDepth, SearchEnvelope search, SearchEnvelope currentExtent, CurveRule curve, long left, long right, ArrayList<LongRange> results) {
        block10: {
            block9: {
                LongRange current;
                if (right - left != 1L) break block9;
                long[] coord = this.normalizedCoordinateFor(left, this.maxLevel);
                if (!search.contains(coord)) break block10;
                LongRange longRange = current = results.size() > 0 ? results.get(results.size() - 1) : null;
                if (current != null && current.max == left - 1L) {
                    current.expandToMax(left);
                } else {
                    current = new LongRange(left);
                    results.add(current);
                }
                if (monitor == null) break block10;
                monitor.addRangeAtDepth(depth);
                monitor.addToCoveredArea(currentExtent.getArea());
                break block10;
            }
            if (search.intersects(currentExtent)) {
                double overlap = search.fractionOf(currentExtent);
                if (config.stopAtThisDepth(overlap, depth, maxDepth)) {
                    LongRange current;
                    LongRange longRange = current = results.size() > 0 ? results.get(results.size() - 1) : null;
                    if (current != null && current.max == left - 1L) {
                        current.expandToMax(right - 1L);
                    } else {
                        current = new LongRange(left, right - 1L);
                        results.add(current);
                    }
                    if (monitor != null) {
                        monitor.addRangeAtDepth(depth);
                        monitor.addToCoveredArea(currentExtent.getArea());
                    }
                } else {
                    long width = (right - left) / (long)this.quadFactor;
                    for (int i = 0; i < this.quadFactor; ++i) {
                        int npoint = curve.npointForIndex(i);
                        SearchEnvelope quadrant = currentExtent.quadrant(this.bitValues(npoint));
                        this.addTilesIntersectingEnvelopeAt(config, monitor, depth + 1, maxDepth, search, quadrant, curve.childAt(i), left + (long)i * width, left + (long)(i + 1) * width, results);
                    }
                }
            }
        }
    }

    private int[] bitValues(int npoint) {
        int[] bitValues = new int[this.nbrDim];
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            int shift = this.nbrDim - dim - 1;
            bitValues[dim] = (npoint & 1 << shift) >> shift;
        }
        return bitValues;
    }

    long[] getNormalizedCoord(double[] coord) {
        long[] normalizedCoord = new long[this.nbrDim];
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            double value = SpaceFillingCurve.clamp(coord[dim], this.range.getMin(dim), this.range.getMax(dim));
            if (value - this.range.getMin(dim) == this.range.getMax(dim) - this.range.getMin(dim)) {
                normalizedCoord[dim] = this.width - 1L;
                continue;
            }
            normalizedCoord[dim] = (long)((value - this.range.getMin(dim)) * this.scalingFactor[dim]);
            double tileCenter = (double)normalizedCoord[dim] / this.scalingFactor[dim] + this.range.getMin(dim) + this.getTileWidth(dim, this.maxLevel) / 2.0;
            long normalizedOffset = (long)((value - tileCenter) * this.scalingFactor[dim] - 0.5 + 1.0E-16);
            int n = dim;
            normalizedCoord[n] = normalizedCoord[n] + normalizedOffset;
        }
        return normalizedCoord;
    }

    private double[] getDoubleCoord(long[] normalizedCoord, int level) {
        double[] coord = new double[this.nbrDim];
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            double coordinate = (double)normalizedCoord[dim] / this.scalingFactor[dim] + this.range.getMin(dim) + this.getTileWidth(dim, level) / 2.0;
            coord[dim] = SpaceFillingCurve.clamp(coordinate, this.range.getMin(dim), this.range.getMax(dim));
        }
        return coord;
    }

    private static double clamp(double val, double min, double max) {
        if (val <= min) {
            return min;
        }
        if (val >= max) {
            return max;
        }
        return val;
    }

    private void assertValidLevel(int level) {
        if (level > this.maxLevel) {
            throw new IllegalArgumentException("Level " + level + " greater than max-level " + this.maxLevel);
        }
    }

    public static class LongRange {
        public final long min;
        public long max;

        LongRange(long value) {
            this(value, value);
        }

        LongRange(long min, long max) {
            this.min = min;
            this.max = max;
        }

        void expandToMax(long other) {
            this.max = other;
        }

        public boolean equals(Object other) {
            return other instanceof LongRange && this.equals((LongRange)other);
        }

        public boolean equals(LongRange other) {
            return this.min == other.min && this.max == other.max;
        }

        public int hashCode() {
            return (int)(this.min << (int)(16L + this.max));
        }

        public String toString() {
            return "LongRange(" + this.min + "," + this.max + ")";
        }
    }

    static abstract class CurveRule {
        final int dimension;
        final int[] npointValues;

        CurveRule(int dimension, int[] npointValues) {
            this.dimension = dimension;
            this.npointValues = npointValues;
            assert (npointValues.length == this.length());
        }

        final int length() {
            return (int)Math.pow(2.0, this.dimension);
        }

        int npointForIndex(int derivedIndex) {
            return this.npointValues[derivedIndex];
        }

        int indexForNPoint(int npoint) {
            for (int index = 0; index < this.npointValues.length; ++index) {
                if (this.npointValues[index] != npoint) continue;
                return index;
            }
            return -1;
        }

        abstract CurveRule childAt(int var1);
    }
}

