/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index;

import java.util.Arrays;

public class Envelope {
    private final double[] min;
    private final double[] max;

    public Envelope(Envelope e) {
        this(e.min, e.max);
    }

    public Envelope(double[] min, double[] max) {
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        if (!this.isValid()) {
            throw new RuntimeException("Invalid envelope created " + this.toString());
        }
    }

    public Envelope(double xmin, double xmax, double ymin, double ymax) {
        this(new double[]{xmin, ymin}, new double[]{xmax, ymax});
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }

    public double getMin(int dimension) {
        return this.min[dimension];
    }

    public double getMax(int dimension) {
        return this.max[dimension];
    }

    public double getMinX() {
        return this.getMin(0);
    }

    public double getMaxX() {
        return this.getMax(0);
    }

    public double getMinY() {
        return this.getMin(1);
    }

    public double getMaxY() {
        return this.getMax(1);
    }

    public int getDimension() {
        return this.min.length;
    }

    public boolean contains(Envelope other) {
        return this.covers(other);
    }

    public boolean covers(Envelope other) {
        boolean covers = this.getDimension() == other.getDimension();
        for (int i = 0; i < this.min.length && covers; ++i) {
            covers = other.min[i] >= this.min[i] && other.max[i] <= this.max[i];
        }
        return covers;
    }

    public boolean intersects(Envelope other) {
        boolean intersects = this.getDimension() == other.getDimension();
        for (int i = 0; i < this.min.length && intersects; ++i) {
            intersects = other.min[i] <= this.max[i] && other.max[i] >= this.min[i];
        }
        return intersects;
    }

    public void expandToInclude(Envelope other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Cannot join Envelopes with different dimensions: " + this.getDimension() + " != " + other.getDimension());
        }
        for (int i = 0; i < this.min.length; ++i) {
            if (other.min[i] < this.min[i]) {
                this.min[i] = other.min[i];
            }
            if (!(other.max[i] > this.max[i])) continue;
            this.max[i] = other.max[i];
        }
    }

    public double distance(Envelope other, int dimension) {
        if (this.min[dimension] < other.min[dimension]) {
            return other.min[dimension] - this.max[dimension];
        }
        return this.min[dimension] - other.max[dimension];
    }

    public double distance(Envelope other) {
        if (this.intersects(other)) {
            return 0.0;
        }
        double distance = 0.0;
        for (int i = 0; i < this.min.length; ++i) {
            double dist = this.distance(other, i);
            if (!(dist > 0.0)) continue;
            distance += dist * dist;
        }
        return Math.sqrt(distance);
    }

    public double getWidth() {
        return this.getWidth(0);
    }

    public double getWidth(int dimension) {
        return this.max[dimension] - this.min[dimension];
    }

    public double[] getWidths(int divisor) {
        double[] widths = Arrays.copyOf(this.max, this.max.length);
        int d = 0;
        while (d < this.max.length) {
            int n = d;
            widths[n] = widths[n] - this.min[d];
            int n2 = d++;
            widths[n2] = widths[n2] / (double)divisor;
        }
        return widths;
    }

    public double getArea() {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            area *= this.max[i] - this.min[i];
        }
        return area;
    }

    public double overlap(Envelope other) {
        Envelope smallest = this.getArea() < other.getArea() ? this : other;
        Envelope intersection = this.intersection(other);
        return intersection == null ? 0.0 : (smallest.isPoint() ? 1.0 : intersection.getArea() / smallest.getArea());
    }

    public boolean isPoint() {
        boolean ans = true;
        for (int i = 0; i < this.min.length && ans; ++i) {
            ans = this.min[i] == this.max[i];
        }
        return ans;
    }

    private boolean isValid() {
        boolean valid = this.min != null && this.max != null && this.min.length == this.max.length;
        for (int i = 0; i < this.min.length && valid; ++i) {
            valid = this.min[i] <= this.max[i];
        }
        return valid;
    }

    public void translate(double[] offset) {
        for (int i = 0; i < Math.min(offset.length, this.min.length); ++i) {
            int n = i;
            this.min[n] = this.min[n] + offset[i];
            int n2 = i;
            this.max[n2] = this.max[n2] + offset[i];
        }
    }

    public String toString() {
        return "Envelope: min=" + Envelope.makeString(this.min) + ", max=" + Envelope.makeString(this.max);
    }

    private static String makeString(double[] vals) {
        StringBuilder sb = new StringBuilder();
        if (vals == null) {
            sb.append("null");
        } else {
            for (double val : vals) {
                if (sb.length() > 0) {
                    sb.append(",");
                } else {
                    sb.append("(");
                }
                sb.append(val);
            }
            if (sb.length() > 0) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public Envelope intersection(Envelope other) {
        if (this.getDimension() == other.getDimension()) {
            double[] i_min = new double[this.min.length];
            double[] i_max = new double[this.min.length];
            Arrays.fill(i_min, Double.NaN);
            Arrays.fill(i_max, Double.NaN);
            boolean result = true;
            for (int i = 0; i < this.min.length; ++i) {
                if (other.min[i] <= this.max[i] && other.max[i] >= this.min[i]) {
                    i_min[i] = Math.max(this.min[i], other.min[i]);
                    i_max[i] = Math.min(this.max[i], other.max[i]);
                    continue;
                }
                result = false;
            }
            return result ? new Envelope(i_min, i_max) : null;
        }
        throw new IllegalArgumentException("Cannot calculate intersection of Envelopes with different dimensions: " + this.getDimension() + " != " + other.getDimension());
    }
}

