/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging.slf4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.neo4j.server.logging.slf4j.SLF4JToLog4jMarker;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;

class SLF4JToLog4jMarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    SLF4JToLog4jMarkerFactory() {
    }

    public Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)name);
        return this.addMarkerIfAbsent(name, log4jMarker);
    }

    private Marker addMarkerIfAbsent(String name, org.apache.logging.log4j.Marker log4jMarker) {
        SLF4JToLog4jMarker marker = new SLF4JToLog4jMarker(this, log4jMarker);
        Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    private Marker getMarker(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        Marker m = (Marker)this.markerMap.get(marker.getName());
        if (m != null) {
            return m;
        }
        return this.addMarkerIfAbsent(marker.getName(), SLF4JToLog4jMarkerFactory.convertMarker(marker));
    }

    org.apache.logging.log4j.Marker getLog4jMarker(Marker marker) {
        if (marker == null) {
            return null;
        }
        if (marker instanceof SLF4JToLog4jMarker) {
            return ((SLF4JToLog4jMarker)marker).getLog4jMarker();
        }
        return ((SLF4JToLog4jMarker)this.getMarker(marker)).getLog4jMarker();
    }

    private static org.apache.logging.log4j.Marker convertMarker(Marker original) {
        if (original == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return SLF4JToLog4jMarkerFactory.convertMarker(original, new ArrayList<Marker>());
    }

    private static org.apache.logging.log4j.Marker convertMarker(Marker original, Collection<Marker> visited) {
        org.apache.logging.log4j.Marker marker = MarkerManager.getMarker((String)original.getName());
        if (original.hasReferences()) {
            for (Marker next : original) {
                if (visited.contains(next)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)next.getName());
                    continue;
                }
                visited.add(next);
                marker.addParents(new org.apache.logging.log4j.Marker[]{SLF4JToLog4jMarkerFactory.convertMarker(next, visited)});
            }
        }
        return marker;
    }

    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    public boolean detachMarker(String name) {
        return false;
    }

    public Marker getDetachedMarker(String name) {
        LOGGER.warn("Log4j does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)name);
        return this.getMarker(name);
    }
}

